/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.util.IDUtil;

class ObjectIdTmp
implements ObjectId {
    private static final long serialVersionUID = 6566399722364067372L;
    private final String entityName;
    private final byte[] id;
    private Map<String, Object> replacementId;

    private ObjectIdTmp() {
        this.entityName = null;
        this.id = null;
    }

    ObjectIdTmp(String entityName, byte[] id) {
        this.id = id;
        this.entityName = entityName;
    }

    ObjectIdTmp(String entityName) {
        this(entityName, IDUtil.pseudoUniqueByteSequence8());
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public byte[] getKey() {
        return this.id;
    }

    @Override
    public Map<String, Object> getIdSnapshot() {
        if (this.replacementId != null) {
            return Collections.unmodifiableMap(this.replacementId);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> getReplacementIdMap() {
        if (this.replacementId == null) {
            this.replacementId = new HashMap<String, Object>();
        }
        return this.replacementId;
    }

    @Override
    public ObjectId createReplacementId() {
        return ObjectId.of(this.entityName, this.replacementId);
    }

    @Override
    public boolean isReplacementIdAttached() {
        return this.replacementId != null && !this.replacementId.isEmpty();
    }

    public String toString() {
        return "<ObjectId:" + this.entityName + ",TEMP:" + this.hashCode() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdTmp that = (ObjectIdTmp)o;
        if (this.id != that.id && !Arrays.equals(this.id, that.id)) {
            return false;
        }
        return this.entityName.equals(that.entityName);
    }

    public int hashCode() {
        return 31 * this.entityName.hashCode() + Arrays.hashCode(this.id);
    }
}

