/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverDataSource
implements DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverDataSource.class);
    protected Driver driver;
    protected String connectionUrl;
    protected String userName;
    protected String password;

    public DriverDataSource(Driver driver, String connectionUrl, String userName, String password) {
        if (connectionUrl == null) {
            throw new NullPointerException("Null 'connectionUrl'");
        }
        this.driver = driver;
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            this.logConnect(this.connectionUrl, userName, password);
            Connection c = null;
            if (this.driver == null) {
                c = DriverManager.getConnection(this.connectionUrl, userName, password);
            } else {
                Properties connectProperties = new Properties();
                if (userName != null) {
                    connectProperties.put("user", userName);
                }
                if (password != null) {
                    connectProperties.put("password", password);
                }
                c = this.driver.connect(this.connectionUrl, connectProperties);
            }
            if (c == null) {
                throw new SQLException("Can't establish connection: " + this.connectionUrl);
            }
            LOGGER.info("+++ Connecting: SUCCESS.");
            return c;
        }
        catch (SQLException ex) {
            LOGGER.info("*** Connecting: FAILURE.", ex);
            throw ex;
        }
    }

    private void logConnect(String url, String userName, String password) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connecting to '" + url + "' as '" + userName + "'");
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return -1;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

