/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.AttributeSet;
import org.apache.cayenne.modeler.dialog.LogConsole;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class ModelerLogger
implements Logger {
    private static final int BUFFER_SIZE = 32;
    private static final byte LOG_LEVEL_INFO = 2;
    private static final byte LOG_LEVEL_DEBUG = 1;
    private static final byte LOG_LEVEL_TRACE = 0;
    private static final byte LOG_LEVEL_WARNING = 3;
    private static final byte LOG_LEVEL_ERROR = 4;
    static final String INFO_LOG_NAME = "INFO";
    private static final String DEBUG_LOG_NAME = "DEBUG";
    private static final String TRACE_LOG_NAME = "TRACE";
    private static final String WARNING_LOG_NAME = "WARNING";
    private static final String ERROR_LOG_NAME = "ERROR";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH.mm.ss";
    private String name;
    private int currentLogLevel = 2;

    public ModelerLogger(String name) {
        this.name = name;
    }

    private String getLogLevel(byte level) {
        switch (level) {
            case 2: {
                return INFO_LOG_NAME;
            }
            case 1: {
                return DEBUG_LOG_NAME;
            }
            case 0: {
                return TRACE_LOG_NAME;
            }
            case 3: {
                return WARNING_LOG_NAME;
            }
            case 4: {
                return ERROR_LOG_NAME;
            }
        }
        throw new IllegalStateException("Unregistered log level - " + level);
    }

    private void consoleLog(byte level, String message, Throwable throwable) {
        if (this.isLevelEnabled(level)) {
            StringBuilder buffer = new StringBuilder(32);
            buffer.append(this.getFormattedDate());
            buffer.append(' ');
            buffer.append('[');
            buffer.append(Thread.currentThread().getName());
            buffer.append("] ");
            buffer.append('[');
            String levelStr = this.getLogLevel(level);
            buffer.append(levelStr);
            buffer.append(']');
            buffer.append(' ');
            buffer.append(message);
            this.write(buffer, throwable);
        }
    }

    private void consoleLog(byte level, String message) {
        this.consoleLog(level, message, null);
    }

    private void consoleLog(byte level, String format, Object ... arguments) {
        if (this.isLevelEnabled(level)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, arguments);
            this.consoleLog(level, tuple.getMessage(), tuple.getThrowable());
        }
    }

    private String getFormattedDate() {
        Date currentDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        String dateText = formatter.format(currentDate);
        return dateText;
    }

    private void write(StringBuilder buffer, Throwable throwable) {
        PrintStream targetStream = System.err;
        targetStream.println(buffer.toString());
        this.writeThrowable(throwable, targetStream);
        targetStream.flush();
    }

    private void writeThrowable(Throwable throwable, PrintStream targetStream) {
        if (throwable != null) {
            throwable.printStackTrace(targetStream);
        }
    }

    private boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    @Override
    public void debug(String message) {
        this.consoleLog((byte)1, message);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE);
    }

    @Override
    public void debug(String message, Object object) {
        this.consoleLog((byte)1, message, object);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object);
    }

    @Override
    public void debug(String message, Object object, Object secondObject) {
        this.consoleLog((byte)1, message, object, secondObject);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object, secondObject);
    }

    @Override
    public void debug(String message, Object ... objects) {
        this.consoleLog((byte)1, message, objects);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, objects);
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.consoleLog((byte)1, message, throwable);
        this.log(DEBUG_LOG_NAME, message, throwable, LogConsole.DEBUG_STYLE);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isLevelEnabled(1);
    }

    @Override
    public void debug(Marker marker, String message) {
        this.consoleLog((byte)1, message);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE);
    }

    @Override
    public void debug(Marker marker, String message, Object object) {
        this.consoleLog((byte)1, message, object);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object);
    }

    @Override
    public void debug(Marker marker, String message, Object object, Object secondObject) {
        this.consoleLog((byte)1, message, object, secondObject);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object, secondObject);
    }

    @Override
    public void debug(Marker marker, String message, Object ... objects) {
        this.consoleLog((byte)1, message, objects);
        this.log(DEBUG_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, objects);
    }

    @Override
    public void debug(Marker marker, String message, Throwable throwable) {
        this.consoleLog((byte)1, message, throwable);
        this.log(DEBUG_LOG_NAME, message, throwable, LogConsole.DEBUG_STYLE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(2);
    }

    @Override
    public void error(String message) {
        this.consoleLog((byte)4, message);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE);
    }

    @Override
    public void error(String message, Object object) {
        this.consoleLog((byte)4, message, object);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE, object);
    }

    @Override
    public void error(String message, Object object, Object secondObject) {
        this.consoleLog((byte)4, message, object, secondObject);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE, object, secondObject);
    }

    @Override
    public void error(String message, Object ... objects) {
        this.consoleLog((byte)4, message, objects);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE, objects);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.consoleLog((byte)4, message, throwable);
        this.log(ERROR_LOG_NAME, message, throwable, LogConsole.ERROR_STYLE);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isLevelEnabled(4);
    }

    @Override
    public void error(Marker marker, String message) {
        this.consoleLog((byte)4, message);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE);
    }

    @Override
    public void error(Marker marker, String message, Object object) {
        this.consoleLog((byte)4, message, object);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE, object);
    }

    @Override
    public void error(Marker marker, String message, Object object, Object secondObject) {
        this.consoleLog((byte)4, message, object, secondObject);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE, object, secondObject);
    }

    @Override
    public void error(Marker marker, String message, Object ... objects) {
        this.consoleLog((byte)4, message, objects);
        this.log(ERROR_LOG_NAME, message, null, LogConsole.ERROR_STYLE, objects);
    }

    @Override
    public void error(Marker marker, String message, Throwable throwable) {
        this.consoleLog((byte)4, message, throwable);
        this.log(ERROR_LOG_NAME, message, throwable, LogConsole.ERROR_STYLE);
    }

    @Override
    public void info(String message) {
        this.consoleLog((byte)2, message);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE);
    }

    @Override
    public void info(String message, Object object) {
        this.consoleLog((byte)2, message, object);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE, object);
    }

    @Override
    public void info(String message, Object object, Object secondObject) {
        this.consoleLog((byte)2, message, object, secondObject);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE, object, secondObject);
    }

    @Override
    public void info(String message, Object ... objects) {
        this.consoleLog((byte)2, message, objects);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE, objects);
    }

    @Override
    public void info(String message, Throwable throwable) {
        this.consoleLog((byte)2, message, throwable);
        this.log(INFO_LOG_NAME, message, throwable, LogConsole.INFO_STYLE);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isLevelEnabled(2);
    }

    @Override
    public void info(Marker marker, String message) {
        this.consoleLog((byte)2, message);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE);
    }

    @Override
    public void info(Marker marker, String message, Object object) {
        this.consoleLog((byte)2, message, object);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE, object);
    }

    @Override
    public void info(Marker marker, String message, Object object, Object secondObject) {
        this.consoleLog((byte)2, message, object, secondObject);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE, object, secondObject);
    }

    @Override
    public void info(Marker marker, String message, Object ... objects) {
        this.consoleLog((byte)2, message, objects);
        this.log(INFO_LOG_NAME, message, null, LogConsole.INFO_STYLE, objects);
    }

    @Override
    public void info(Marker marker, String message, Throwable throwable) {
        this.consoleLog((byte)2, message, throwable);
        this.log(INFO_LOG_NAME, message, throwable, LogConsole.INFO_STYLE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(3);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    @Override
    public void trace(String message) {
        this.consoleLog((byte)0, message);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE);
    }

    @Override
    public void trace(String message, Object object) {
        this.consoleLog((byte)0, message, object);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object);
    }

    @Override
    public void trace(String message, Object object, Object secondObject) {
        this.consoleLog((byte)0, message, object, secondObject);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object, secondObject);
    }

    @Override
    public void trace(String message, Object ... objects) {
        this.consoleLog((byte)0, message, objects);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, objects);
    }

    @Override
    public void trace(String message, Throwable throwable) {
        this.consoleLog((byte)0, message, throwable);
        this.log(TRACE_LOG_NAME, message, throwable, LogConsole.DEBUG_STYLE);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isLevelEnabled(0);
    }

    @Override
    public void trace(Marker marker, String message) {
        this.consoleLog((byte)0, message);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE);
    }

    @Override
    public void trace(Marker marker, String message, Object object) {
        this.consoleLog((byte)0, message, object);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object);
    }

    @Override
    public void trace(Marker marker, String message, Object object, Object secondObject) {
        this.consoleLog((byte)0, message, object, secondObject);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, object, secondObject);
    }

    @Override
    public void trace(Marker marker, String message, Object ... objects) {
        this.consoleLog((byte)0, message, objects);
        this.log(TRACE_LOG_NAME, message, null, LogConsole.DEBUG_STYLE, objects);
    }

    @Override
    public void trace(Marker marker, String message, Throwable throwable) {
        this.consoleLog((byte)0, message, throwable);
        this.log(TRACE_LOG_NAME, message, throwable, LogConsole.DEBUG_STYLE);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isErrorEnabled();
    }

    @Override
    public void warn(String message) {
        this.consoleLog((byte)3, message);
        this.log("WARN", message, null, LogConsole.WARN_STYLE);
    }

    @Override
    public void warn(String message, Object object) {
        this.consoleLog((byte)3, message, object);
        this.log("WARN", message, null, LogConsole.WARN_STYLE, object);
    }

    @Override
    public void warn(String message, Object ... objects) {
        this.consoleLog((byte)3, message, objects);
        this.log("WARN", message, null, LogConsole.WARN_STYLE, objects);
    }

    @Override
    public void warn(String message, Object object, Object secondObject) {
        this.consoleLog((byte)3, message, object, secondObject);
        this.log("WARN", message, null, LogConsole.WARN_STYLE, object, secondObject);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.consoleLog((byte)3, message, throwable);
        this.log("WARN", message, throwable, LogConsole.WARN_STYLE);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isLevelEnabled(3);
    }

    @Override
    public void warn(Marker marker, String message) {
        this.consoleLog((byte)3, message);
        this.log("WARN", message, null, LogConsole.WARN_STYLE);
    }

    @Override
    public void warn(Marker marker, String message, Object object) {
        this.consoleLog((byte)3, message, object);
        this.log("WARN", message, null, LogConsole.WARN_STYLE, object);
    }

    @Override
    public void warn(Marker marker, String message, Object object, Object secondObject) {
        this.consoleLog((byte)3, message, object, secondObject);
        this.log("WARN", message, null, LogConsole.WARN_STYLE, object, secondObject);
    }

    @Override
    public void warn(Marker marker, String message, Object ... objects) {
        this.consoleLog((byte)3, message, objects);
        this.log("WARN", message, null, LogConsole.WARN_STYLE, objects);
    }

    @Override
    public void warn(Marker marker, String message, Throwable throwable) {
        this.consoleLog((byte)3, message, throwable);
        this.log("WARN", message, throwable, LogConsole.WARN_STYLE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(4);
    }

    void log(String level, String message, Throwable throwable, AttributeSet style, Object ... parameters) {
        FormattingTuple tuple = MessageFormatter.arrayFormat(message, parameters);
        this.getLogConsole().appendMessage(level, tuple.getMessage(), throwable, style);
    }

    void log(String level, Object message, Throwable throwable, AttributeSet style) {
        this.getLogConsole().appendMessage(level, String.valueOf(message), throwable, style);
    }

    private LogConsole getLogConsole() {
        return LogConsole.getInstance();
    }
}

