/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.undo.RemoveUndoableEdit;

public class RemoveEntityAction
extends RemoveAction {
    GraphBuilder builder;

    public RemoveEntityAction(GraphBuilder builder) {
        super(Application.getInstance());
        this.builder = builder;
        this.setEnabled(true);
    }

    @Override
    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        Entity entity = this.builder.getSelectedEntity();
        if (entity == null) {
            return;
        }
        if (entity instanceof ObjEntity) {
            if (dialog.shouldDelete("ObjEntity", entity.getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(entity.getDataMap(), (ObjEntity)entity));
                this.removeObjEntity(entity.getDataMap(), (ObjEntity)entity);
            }
        } else if (dialog.shouldDelete("DbEntity", entity.getName())) {
            this.application.getUndoManager().addEdit(new RemoveUndoableEdit(entity.getDataMap(), (DbEntity)entity));
            this.removeDbEntity(entity.getDataMap(), (DbEntity)entity);
        }
    }
}

