/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.oracle.Oracle8Adapter;
import org.apache.cayenne.dba.oracle.Oracle8LOBBatchQueryWrapper;
import org.apache.cayenne.dba.oracle.Oracle8LOBBatchTranslator;
import org.apache.cayenne.dba.oracle.Oracle8LOBInsertBatchTranslator;
import org.apache.cayenne.dba.oracle.Oracle8LOBUpdateBatchTranslator;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.UpdateBatchQuery;
import org.apache.cayenne.util.Util;

class Oracle8LOBBatchAction
implements SQLAction {
    private BatchQuery query;
    private DbAdapter adapter;
    private JdbcEventLogger logger;

    private static void bind(DbAdapter adapter, PreparedStatement statement, DbAttributeBinding[] bindings) throws SQLException, Exception {
        for (DbAttributeBinding b : bindings) {
            DbAttributeBinding binding = new DbAttributeBinding(b.getAttribute());
            adapter.bindParameter(statement, binding);
        }
    }

    Oracle8LOBBatchAction(BatchQuery query, DbAdapter adapter, JdbcEventLogger logger) {
        this.adapter = adapter;
        this.query = query;
        this.logger = logger;
    }

    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        Oracle8LOBBatchTranslator translator;
        if (this.query instanceof InsertBatchQuery) {
            translator = new Oracle8LOBInsertBatchTranslator((InsertBatchQuery)this.query, this.adapter, "RTRIM");
        } else if (this.query instanceof UpdateBatchQuery) {
            translator = new Oracle8LOBUpdateBatchTranslator((UpdateBatchQuery)this.query, this.adapter, "RTRIM");
        } else {
            throw new CayenneException("Unsupported batch type for special LOB processing: " + this.query, new Object[0]);
        }
        translator.setNewBlobFunction("EMPTY_BLOB()");
        translator.setNewClobFunction("EMPTY_CLOB()");
        Oracle8LOBBatchQueryWrapper selectQuery = new Oracle8LOBBatchQueryWrapper(this.query);
        List<DbAttribute> qualifierAttributes = selectQuery.getDbAttributesForLOBSelectQualifier();
        for (BatchQueryRow row : this.query.getRows()) {
            int updated;
            selectQuery.indexLOBAttributes(row);
            String updateStr = translator.createSql(row);
            this.logger.log(updateStr);
            try (PreparedStatement statement = connection.prepareStatement(updateStr);){
                ParameterBinding[] bindings = translator.updateBindings(row);
                this.logger.logQueryParameters("bind", bindings);
                Oracle8LOBBatchAction.bind(this.adapter, statement, (DbAttributeBinding[])bindings);
                updated = statement.executeUpdate();
                this.logger.logUpdateCount(updated);
            }
            this.processLOBRow(connection, translator, selectQuery, qualifierAttributes, row);
            observer.nextCount(this.query, updated);
        }
    }

    void processLOBRow(Connection con, Oracle8LOBBatchTranslator queryBuilder, Oracle8LOBBatchQueryWrapper selectQuery, List<DbAttribute> qualifierAttributes, BatchQueryRow row) throws SQLException, Exception {
        List<DbAttribute> lobAttributes = selectQuery.getDbAttributesForUpdatedLOBColumns();
        if (lobAttributes.size() == 0) {
            return;
        }
        boolean isLoggable = this.logger.isLoggable();
        List<Object> qualifierValues = selectQuery.getValuesForLOBSelectQualifier(row);
        List<Object> lobValues = selectQuery.getValuesForUpdatedLOBColumns();
        int parametersSize = qualifierValues.size();
        int lobSize = lobAttributes.size();
        String selectStr = queryBuilder.createLOBSelectString(lobAttributes, qualifierAttributes);
        try (PreparedStatement selectStatement = con.prepareStatement(selectStr);){
            ParameterBinding[] attributeBindings = null;
            if (isLoggable) {
                attributeBindings = new DbAttributeBinding[parametersSize];
            }
            for (int i = 0; i < parametersSize; ++i) {
                DbAttribute attribute = qualifierAttributes.get(i);
                Object value = qualifierValues.get(i);
                ExtendedType extendedType = value != null ? this.adapter.getExtendedTypes().getRegisteredType(value.getClass()) : this.adapter.getExtendedTypes().getDefaultType();
                DbAttributeBinding binding = new DbAttributeBinding(attribute);
                binding.setStatementPosition(i + 1);
                binding.setValue(value);
                binding.setExtendedType(extendedType);
                this.adapter.bindParameter(selectStatement, binding);
                if (!isLoggable) continue;
                attributeBindings[i] = binding;
            }
            if (isLoggable) {
                this.logger.logQuery(selectStr, attributeBindings);
            }
            try (ResultSet result = selectStatement.executeQuery();){
                if (!result.next()) {
                    throw new CayenneRuntimeException("Missing LOB row.", new Object[0]);
                }
                for (int i = 0; i < lobSize; ++i) {
                    DbAttribute attribute = lobAttributes.get(i);
                    int type = attribute.getType();
                    if (type == 2005) {
                        Clob clob = result.getClob(i + 1);
                        Object clobVal = lobValues.get(i);
                        if (clobVal instanceof char[]) {
                            this.writeClob(clob, (char[])clobVal);
                            continue;
                        }
                        this.writeClob(clob, clobVal.toString());
                        continue;
                    }
                    if (type == 2004) {
                        Blob blob = result.getBlob(i + 1);
                        Object blobVal = lobValues.get(i);
                        if (blobVal instanceof byte[]) {
                            this.writeBlob(blob, (byte[])blobVal);
                            continue;
                        }
                        String className = blobVal != null ? blobVal.getClass().getName() : null;
                        throw new CayenneRuntimeException("Unsupported class of BLOB value: %s", className);
                    }
                    throw new CayenneRuntimeException("Only BLOB or CLOB is expected here, got: %s", type);
                }
                if (result.next()) {
                    throw new CayenneRuntimeException("More than one LOB row found.", new Object[0]);
                }
            }
        }
    }

    protected void writeBlob(Blob blob, byte[] value) {
        Method getBinaryStreamMethod = Oracle8Adapter.getOutputStreamFromBlobMethod();
        try (OutputStream out = (OutputStream)getBinaryStreamMethod.invoke((Object)blob, (Object[])null);){
            out.write(value);
            out.flush();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing BLOB.", Util.unwindException(e), new Object[0]);
        }
    }

    protected void writeClob(Clob clob, char[] value) {
        Method getWriterMethod = Oracle8Adapter.getWriterFromClobMethod();
        try (Writer out = (Writer)getWriterMethod.invoke((Object)clob, (Object[])null);){
            out.write(value);
            out.flush();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing CLOB.", Util.unwindException(e), new Object[0]);
        }
    }

    protected void writeClob(Clob clob, String value) {
        Method getWriterMethod = Oracle8Adapter.getWriterFromClobMethod();
        try (Writer out = (Writer)getWriterMethod.invoke((Object)clob, (Object[])null);){
            out.write(value);
            out.flush();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing CLOB.", Util.unwindException(e), new Object[0]);
        }
    }
}

