/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIDataSourceFactory
implements DataSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JNDIDataSourceFactory.class);

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        String location = this.getLocation(nodeDescriptor);
        try {
            return this.lookupViaJNDI(location);
        }
        catch (Exception e) {
            LOGGER.info("*** failed JNDI lookup of DataSource at location: " + location, (Throwable)e);
            throw e;
        }
    }

    protected String getLocation(DataNodeDescriptor nodeDescriptor) {
        String location = nodeDescriptor.getParameters();
        if (location == null) {
            throw new CayenneRuntimeException("Null 'location' for nodeDescriptor '%s'", nodeDescriptor.getName());
        }
        return location;
    }

    DataSource lookupViaJNDI(String location) throws NamingException {
        DataSource dataSource;
        LOGGER.info("Connecting. JNDI path: " + location);
        InitialContext context = new InitialContext();
        try {
            Context envContext = (Context)context.lookup("java:comp/env");
            dataSource = (DataSource)envContext.lookup(location);
        }
        catch (NamingException namingEx) {
            dataSource = (DataSource)context.lookup(location);
        }
        LOGGER.info("Found JNDI DataSource at location: " + location);
        return dataSource;
    }
}

