/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class DateType
implements ExtendedType<Date> {
    @Override
    public String getClassName() {
        return Date.class.getName();
    }

    @Override
    public Date materializeObject(ResultSet rs, int index, int type) throws Exception {
        return rs.getDate(index);
    }

    @Override
    public Date materializeObject(CallableStatement rs, int index, int type) throws Exception {
        return rs.getDate(index);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Date value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setDate(pos, value);
        }
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return "NULL";
        }
        return '\'' + value.toString() + '\'';
    }
}

