/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.commons.lang.StringUtils;

public abstract class PathChooserComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
PopupMenuListener {
    protected JComboBox<String> comboBoxPathChooser;
    protected int previousEmbeddedLevel = 0;
    protected EntityTreeModel treeModel;
    protected int row;
    private JTable table;

    protected abstract void enterPressed(JTable var1);

    protected abstract EntityTreeModel createTreeModelForComboBox(int var1);

    protected abstract Object getCurrentNodeToInitializeCombo(CayenneTableModel var1, int var2);

    protected abstract String getPathToInitializeCombo(CayenneTableModel var1, int var2);

    protected void initializeCombo(CayenneTableModel model, int row, final JTable table) {
        Object currentNode = this.getCurrentNodeToInitializeCombo(model, row);
        String dbAttributePath = this.getPathToInitializeCombo(model, row);
        List<String> nodeChildren = this.getChildren(currentNode, dbAttributePath);
        this.table = table;
        this.comboBoxPathChooser = Application.getWidgetFactory().createComboBox(nodeChildren, false);
        this.comboBoxPathChooser.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    PathChooserComboBoxCellEditor.this.enterPressed(table);
                    return;
                }
                PathChooserComboBoxCellEditor.this.parsePathString(event.getKeyChar());
            }
        });
        AutoCompletion.enable(this.comboBoxPathChooser, true, true);
        ((JComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).setBorder(null);
        this.comboBoxPathChooser.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.comboBoxPathChooser.setRenderer(new PathChooserComboBoxCellRenderer());
        this.comboBoxPathChooser.addActionListener(this);
        this.comboBoxPathChooser.addPopupMenuListener(this);
    }

    private void setComboModelAccordingToPath(String pathString) {
        ArrayList<String> currentNodeChildren = new ArrayList<String>();
        currentNodeChildren.addAll(this.getChildren(this.getCurrentNode(pathString), pathString));
        this.comboBoxPathChooser.setModel(new DefaultComboBoxModel<String>(currentNodeChildren.toArray(new String[0])));
        this.comboBoxPathChooser.setSelectedItem(pathString);
        if (!pathString.isEmpty()) {
            this.comboBoxPathChooser.showPopup();
        }
    }

    protected void parsePathString(char lastEnteredCharacter) {
        JTextComponent editorComponent = (JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent();
        String pathString = editorComponent.getText();
        if (pathString != null && pathString.isEmpty()) {
            this.setComboModelAccordingToPath("");
            this.previousEmbeddedLevel = 0;
            return;
        }
        if (lastEnteredCharacter == '.') {
            this.processDotEntered();
            this.previousEmbeddedLevel = StringUtils.countMatches(pathString, ".");
            return;
        }
        int currentEmbeddedLevel = StringUtils.countMatches(pathString, ".");
        if (this.previousEmbeddedLevel != currentEmbeddedLevel) {
            this.previousEmbeddedLevel = currentEmbeddedLevel;
            String[] pathStrings = pathString.split(Pattern.quote("."));
            String lastStringInPath = pathStrings[pathStrings.length - 1];
            String saveDbAttributePath = pathString;
            pathString = pathString.replaceAll(lastStringInPath + "$", "");
            ArrayList<String> currentNodeChildren = new ArrayList<String>();
            currentNodeChildren.addAll(this.getChildren(this.getCurrentNode(pathString), pathString));
            this.comboBoxPathChooser.setModel(new DefaultComboBoxModel<String>(currentNodeChildren.toArray(new String[0])));
            this.comboBoxPathChooser.setSelectedItem(saveDbAttributePath);
        }
    }

    protected void processDotEntered() {
        JTextComponent editorComponent = (JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent();
        String dbAttributePath = editorComponent.getText();
        if (".".equals(dbAttributePath)) {
            this.setComboModelAccordingToPath("");
            return;
        }
        char secondFromEndCharacter = dbAttributePath.charAt(dbAttributePath.length() - 2);
        if (secondFromEndCharacter == '.') {
            editorComponent.setText(dbAttributePath.substring(0, dbAttributePath.length() - 1));
            return;
        }
        String[] pathStrings = dbAttributePath.split(Pattern.quote("."));
        String lastStringInPath = pathStrings[pathStrings.length - 1];
        String dbAttributePathForPreviousNode = pathStrings.length == 1 ? "" : dbAttributePath.replaceAll('.' + lastStringInPath + ".$", "");
        List<String> potentialVariantsToChoose = this.getChildren(this.getCurrentNode(dbAttributePathForPreviousNode), "");
        if (potentialVariantsToChoose.contains(lastStringInPath) && !(this.getCurrentNode(dbAttributePath) instanceof DbAttribute)) {
            this.setComboModelAccordingToPath(dbAttributePath);
        } else {
            editorComponent.setText(dbAttributePath.substring(0, dbAttributePath.length() - 1));
        }
    }

    protected Object getCurrentNode(String pathString) {
        if (pathString == null || pathString.isEmpty()) {
            return this.treeModel.getRoot();
        }
        String[] pathStrings = pathString.split(Pattern.quote("."));
        Object root = this.treeModel.getRoot();
        block0: for (String rootChildText : pathStrings) {
            for (int j = 0; j < this.treeModel.getChildCount(root); ++j) {
                Object child = this.treeModel.getChild(root, j);
                String objectName = ModelerUtil.getObjectName(child);
                if (!objectName.equals(rootChildText)) continue;
                root = child;
                continue block0;
            }
        }
        return root;
    }

    protected List<String> getChildren(Object node, String pathString) {
        ArrayList<String> currentNodeChildren = new ArrayList<String>();
        for (int j = 0; j < this.treeModel.getChildCount(node); ++j) {
            Object child = this.treeModel.getChild(node, j);
            String relationshipName = ModelerUtil.getObjectName(child);
            currentNodeChildren.add(pathString + relationshipName);
        }
        return currentNodeChildren;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.comboBoxPathChooser.getSelectedIndex() != -1) {
            ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).setText(this.comboBoxPathChooser.getSelectedItem().toString());
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.comboBoxPathChooser.getSelectedIndex() != -1 && !((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).getText().isEmpty()) {
            this.enterPressed(this.table);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private final class PathChooserComboBoxCellRenderer
    extends DefaultListCellRenderer {
        private final ImageIcon rightArrow = ModelerUtil.buildIcon("icon-arrow-closed.png");

        private PathChooserComboBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel((String)value);
            panel.add(label);
            Object currentNode = PathChooserComboBoxCellEditor.this.getCurrentNode((String)value);
            if (PathChooserComboBoxCellEditor.this.treeModel.isLeaf(currentNode)) {
                ListCellRenderer<Object> leafRenderer = CellRenderers.listRenderer();
                return leafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            DefaultListCellRenderer nonLeafTextRenderer = new DefaultListCellRenderer();
            Component text = nonLeafTextRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            panel.setBackground(text.getBackground());
            panel.add((Component)new JLabel(this.rightArrow), "East");
            return panel;
        }
    }
}

