/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;

public class CompoundDiff
implements GraphDiff {
    private static final long serialVersionUID = 5930690302335603082L;
    protected List<GraphDiff> diffs;

    public CompoundDiff() {
    }

    public CompoundDiff(List<GraphDiff> diffs) {
        this.diffs = diffs;
    }

    @Override
    public boolean isNoop() {
        if (this.diffs == null || this.diffs.isEmpty()) {
            return true;
        }
        for (GraphDiff diff : this.diffs) {
            if (diff.isNoop()) continue;
            return false;
        }
        return true;
    }

    public List<GraphDiff> getDiffs() {
        return this.diffs != null ? Collections.unmodifiableList(this.diffs) : Collections.emptyList();
    }

    public void add(GraphDiff diff) {
        this.nonNullDiffs().add(diff);
    }

    public void addAll(Collection<? extends GraphDiff> diffs) {
        this.nonNullDiffs().addAll(diffs);
    }

    @Override
    public void apply(GraphChangeHandler tracker) {
        if (this.diffs == null) {
            return;
        }
        for (GraphDiff change : this.diffs) {
            change.apply(tracker);
        }
    }

    @Override
    public void undo(GraphChangeHandler tracker) {
        if (this.diffs == null) {
            return;
        }
        ListIterator<GraphDiff> it = this.diffs.listIterator(this.diffs.size());
        while (it.hasPrevious()) {
            GraphDiff change = it.previous();
            change.undo(tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GraphDiff> nonNullDiffs() {
        if (this.diffs == null) {
            CompoundDiff compoundDiff = this;
            synchronized (compoundDiff) {
                if (this.diffs == null) {
                    this.diffs = new ArrayList<GraphDiff>();
                }
            }
        }
        return this.diffs;
    }
}

