/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKey;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DetectedDbEntity;
import org.apache.cayenne.map.Procedure;

public class DbLoadDataStore
extends DataMap {
    private Map<String, Set<ExportedKey>> exportedKeys = new HashMap<String, Set<ExportedKey>>();
    private Map<String, DbEntity> upperCaseNames = new HashMap<String, DbEntity>();

    DbLoadDataStore() {
        super("__generated_by_dbloader__");
    }

    @Override
    public DbEntity getDbEntity(String dbEntityName) {
        return this.upperCaseNames.get(dbEntityName.toUpperCase());
    }

    @Override
    public void addDbEntity(DbEntity entity) {
        if (!(entity instanceof DetectedDbEntity)) {
            throw new IllegalArgumentException("Only DetectedDbEntity can be inserted in this map");
        }
        super.addDbEntity(entity);
        this.upperCaseNames.put(entity.getName().toUpperCase(), entity);
    }

    DbEntity addDbEntitySafe(DbEntity entity) {
        if (!(entity instanceof DetectedDbEntity)) {
            throw new IllegalArgumentException("Only DetectedDbEntity can be inserted in this map");
        }
        DbEntity old = this.getDbEntity(entity.getName());
        if (old != null) {
            this.removeDbEntity(old.getName());
        }
        this.addDbEntity(entity);
        return old;
    }

    void addProcedureSafe(Procedure procedure) {
        Procedure old = this.getProcedure(procedure.getName());
        if (old != null) {
            this.removeProcedure(old.getName());
        }
        this.addProcedure(procedure);
    }

    void addExportedKey(ExportedKey key) {
        Set<ExportedKey> exportedKeys = this.exportedKeys.get(key.getStrKey());
        if (exportedKeys == null) {
            exportedKeys = new TreeSet<ExportedKey>();
            this.exportedKeys.put(key.getStrKey(), exportedKeys);
        }
        exportedKeys.add(key);
    }

    Set<Map.Entry<String, Set<ExportedKey>>> getExportedKeysEntrySet() {
        return this.exportedKeys.entrySet();
    }
}

