/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.Iterator;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.DigraphIteration;
import org.apache.cayenne.ashwood.graph.EmptyIterator;
import org.apache.cayenne.ashwood.graph.FilterArcIterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;

public class FilterIteration<E, V>
implements DigraphIteration<E, V> {
    private DigraphIteration<E, V> digraph;
    private Predicate acceptVertex;
    private Predicate acceptArc;

    public FilterIteration(DigraphIteration<E, V> digraph, Predicate acceptVertex, Predicate acceptArc) {
        this.digraph = digraph;
        this.acceptVertex = acceptVertex;
        this.acceptArc = acceptArc;
    }

    @Override
    public Iterator<E> vertexIterator() {
        return IteratorUtils.filteredIterator(this.digraph.vertexIterator(), this.acceptVertex);
    }

    @Override
    public ArcIterator<E, V> arcIterator() {
        return new FilterArcIterator<E, V>(this.digraph.arcIterator(), this.acceptVertex, this.acceptVertex, this.acceptArc);
    }

    @Override
    public ArcIterator<E, V> outgoingIterator(E vertex) {
        if (!this.acceptVertex.evaluate(vertex)) {
            return EmptyIterator.instance();
        }
        return new FilterArcIterator<E, V>(this.digraph.outgoingIterator(vertex), TruePredicate.INSTANCE, this.acceptVertex, this.acceptArc);
    }

    @Override
    public ArcIterator<E, V> incomingIterator(E vertex) {
        if (!this.acceptVertex.evaluate(vertex)) {
            return EmptyIterator.instance();
        }
        return new FilterArcIterator<E, V>(this.digraph.incomingIterator(vertex), this.acceptVertex, TruePredicate.INSTANCE, this.acceptArc);
    }
}

