package org.apache.cayenne.testdo.things.auto;

import java.util.List;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.things.Bag;
import org.apache.cayenne.testdo.things.Ball;
import org.apache.cayenne.testdo.things.BoxInfo;
import org.apache.cayenne.testdo.things.Thing;

/**
 * Class _Box was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Box extends CayenneDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String ID_PK_COLUMN = "ID";

    public static final Property<String> NAME = Property.create("name", String.class);
    public static final Property<Bag> BAG = Property.create("bag", Bag.class);
    public static final Property<List<Ball>> BALLS = Property.create("balls", List.class);
    public static final Property<BoxInfo> BOX_INFO = Property.create("boxInfo", BoxInfo.class);
    public static final Property<List<Thing>> THINGS = Property.create("things", List.class);

    public void setName(String name) {
        writeProperty("name", name);
    }
    public String getName() {
        return (String)readProperty("name");
    }

    public void setBag(Bag bag) {
        setToOneTarget("bag", bag, true);
    }

    public Bag getBag() {
        return (Bag)readProperty("bag");
    }


    public void addToBalls(Ball obj) {
        addToManyTarget("balls", obj, true);
    }
    public void removeFromBalls(Ball obj) {
        removeToManyTarget("balls", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Ball> getBalls() {
        return (List<Ball>)readProperty("balls");
    }


    public void setBoxInfo(BoxInfo boxInfo) {
        setToOneTarget("boxInfo", boxInfo, true);
    }

    public BoxInfo getBoxInfo() {
        return (BoxInfo)readProperty("boxInfo");
    }


    @SuppressWarnings("unchecked")
    public List<Thing> getThings() {
        return (List<Thing>)readProperty("things");
    }


}
