/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.xml;

import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.xml.XMLMappingDescriptor;
import org.apache.cayenne.xml.XMLSerializable;
import org.apache.cayenne.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class XMLEncoder {
    private XMLMappingDescriptor mappingDescriptor;
    private Document document;
    private Node parent;
    private String tagOverride;
    private boolean inProgress;

    public XMLEncoder() {
    }

    public XMLEncoder(String mappingUrl) {
        this.mappingDescriptor = new XMLMappingDescriptor(mappingUrl);
    }

    public void setRoot(String xmlTag, String type) {
        this.setRoot(xmlTag, type, true);
    }

    public void encodeProperty(String xmlTag, Object value) {
        this.encodeProperty(xmlTag, value, true);
    }

    public String encode(Object object) throws CayenneRuntimeException {
        return this.encode("root", object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(String rootTag, Object object) throws CayenneRuntimeException {
        try {
            this.initDocument(rootTag, object != null ? object.getClass().getName() : null);
            if (this.mappingDescriptor != null) {
                this.mappingDescriptor.getRootEntity().setObject(object);
                this.mappingDescriptor.getRootEntity().encodeAsXML(this);
            } else {
                this.encodeProperty(rootTag, object);
            }
            if (object instanceof Collection) {
                String string = this.nodeToString(this.getRootNode(true));
                return string;
            }
            String string = this.nodeToString(this.getRootNode(false));
            return string;
        }
        finally {
            this.inProgress = false;
        }
    }

    protected void initDocument(String rootTag, String type) {
        this.document = XMLUtil.newBuilder().newDocument();
        this.parent = this.document;
        Element root = this.push(rootTag);
        if (type != null) {
            root.setAttribute("type", type);
        }
        this.inProgress = true;
    }

    protected Node getRootNode(boolean forceSyntheticRoot) {
        if (this.document == null) {
            return null;
        }
        Node root = this.document.getDocumentElement();
        if (!forceSyntheticRoot && root.getChildNodes().getLength() == 1) {
            root = root.getFirstChild();
        }
        return root;
    }

    protected String nodeToString(Node rootNode) {
        StringWriter out = new StringWriter();
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(rootNode);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("method", "xml");
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("omit-xml-declaration", "yes");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("XML transformation error", (Throwable)e, new Object[0]);
        }
        return out.toString().trim() + System.getProperty("line.separator");
    }

    protected void setRoot(String xmlTag, String type, boolean push) {
        if (!this.inProgress) {
            this.initDocument(xmlTag, type);
        }
        if (this.tagOverride != null) {
            xmlTag = this.tagOverride;
            this.tagOverride = null;
        }
        if (!push) {
            this.pop();
        }
        Element element = this.push(xmlTag);
        if (type != null) {
            element.setAttribute("type", type);
        }
    }

    protected void encodeProperty(String xmlTag, Object value, boolean useType) {
        if (!this.inProgress) {
            String type = useType && value != null ? value.getClass().getName() : null;
            this.initDocument(xmlTag, type);
        }
        if (value == null) {
            return;
        }
        if (value instanceof XMLSerializable) {
            this.encodeSerializable(xmlTag, (XMLSerializable)value);
        } else if (value instanceof Collection) {
            this.encodeCollection(xmlTag, (Collection)value, useType);
        } else {
            this.encodeSimple(xmlTag, value, useType);
        }
    }

    protected void encodeSimple(String xmlTag, Object object, boolean useType) {
        Element node = this.push(xmlTag);
        if (useType) {
            node.setAttribute("type", object.getClass().getName());
        }
        if (object instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
            node.appendChild(this.document.createTextNode(sdf.format(object)));
        } else {
            node.appendChild(this.document.createTextNode(object.toString()));
        }
        this.pop();
    }

    protected void encodeSerializable(String xmlTag, XMLSerializable object) {
        if (this.document.getDocumentElement() != this.parent) {
            this.tagOverride = xmlTag;
        }
        object.encodeAsXML(this);
        this.tagOverride = null;
        this.pop();
    }

    protected void encodeCollection(String xmlTag, Collection<Object> c, boolean useType) {
        for (Object o : c) {
            this.encodeProperty(xmlTag, o, useType);
        }
        if (c.size() == 1) {
            ((Element)this.parent.getLastChild()).setAttribute("forceList", "YES");
        }
    }

    private Element push(String xmlTag) {
        Element child = this.document.createElement(xmlTag);
        this.parent.appendChild(child);
        this.parent = child;
        return child;
    }

    Node pop() {
        Node old = this.parent;
        this.parent = this.parent.getParentNode();
        return old;
    }
}

