/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.wocompat;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.wocompat.parser.Parser;
import org.apache.commons.collections.IteratorUtils;

public class EOModelHelper {
    private static final ResourceLocator locator = new ResourceLocator();
    private Parser plistParser = new Parser();
    protected URL modelUrl;
    protected Map entityIndex;
    protected Map entityClassIndex;
    protected Map entityQueryIndex;
    protected Map entityClientClassIndex;
    protected DataMap dataMap;
    private Map prototypeValues;

    public EOModelHelper(String path) throws Exception {
        Map entityPlistMap;
        String name;
        this.modelUrl = this.findModelUrl(path);
        this.dataMap = new DataMap(this.findModelName(path));
        List modelIndex = (List)this.loadModelIndex().get("entities");
        this.entityIndex = new HashMap();
        this.entityClassIndex = new HashMap();
        this.entityClientClassIndex = new HashMap();
        this.entityQueryIndex = new HashMap();
        for (Map info : modelIndex) {
            name = (String)info.get("name");
            this.entityIndex.put(name, this.loadEntityIndex(name));
            this.entityQueryIndex.put(name, this.loadQueryIndex(name));
            this.entityClassIndex.put(name, info.get("className"));
            entityPlistMap = this.entityPListMap(name);
            Map internalInfo = (Map)entityPlistMap.get("internalInfo");
            if (internalInfo == null) continue;
            String clientClassName = (String)internalInfo.get("_javaClientClassName");
            this.entityClientClassIndex.put(name, clientClassName);
        }
        for (Map info : modelIndex) {
            Map internalInfo;
            List clientClassProperties;
            name = (String)info.get("name");
            entityPlistMap = this.entityPListMap(name);
            List classProperties = (List)entityPlistMap.get("classProperties");
            if (classProperties == null) {
                classProperties = Collections.EMPTY_LIST;
            }
            List list = clientClassProperties = (internalInfo = (Map)entityPlistMap.get("internalInfo")) != null ? (List)internalInfo.get("_clientClassPropertyNames") : null;
            if (clientClassProperties == null) {
                clientClassProperties = Collections.EMPTY_LIST;
            }
            clientClassProperties.retainAll(classProperties);
            String parentEntity = (String)entityPlistMap.get("parent");
            while (parentEntity != null) {
                Map parentEntityPListMap = this.entityPListMap(parentEntity);
                List parentClassProps = (List)parentEntityPListMap.get("classProperties");
                classProperties.removeAll(parentClassProps);
                Map parentInternalInfo = (Map)parentEntityPListMap.get("internalInfo");
                if (parentInternalInfo != null) {
                    List parentClientClassProps = (List)parentInternalInfo.get("_clientClassPropertyNames");
                    clientClassProperties.removeAll(parentClientClassProps);
                }
                parentEntity = (String)parentEntityPListMap.get("parent");
            }
            entityPlistMap.put("classProperties", classProperties);
            entityPlistMap.put("clientClassProperties", clientClassProperties);
        }
    }

    public String javaTypeForEOModelerType(String valueClassName, String valueType) {
        if (valueClassName == null) {
            return null;
        }
        if (valueClassName.equals("NSString")) {
            return String.class.getName();
        }
        if (valueClassName.equals("NSNumber")) {
            Class numericClass = this.numericAttributeClass(valueType);
            return numericClass != null ? numericClass.getName() : Number.class.getName();
        }
        if (valueClassName.equals("NSCalendarDate")) {
            return "java.sql.Timestamp";
        }
        if (valueClassName.equals("NSDecimalNumber")) {
            Class numericClass = this.numericAttributeClass(valueType);
            return numericClass != null ? numericClass.getName() : BigDecimal.class.getName();
        }
        if (valueClassName.equals("NSData")) {
            return "byte[]";
        }
        try {
            return Class.forName(valueClassName).getName();
        }
        catch (ClassNotFoundException aClassNotFoundException) {
            try {
                return Class.forName("java.lang." + valueClassName).getName();
            }
            catch (ClassNotFoundException anotherClassNotFoundException) {
                try {
                    return Class.forName("java.util." + valueClassName).getName();
                }
                catch (ClassNotFoundException yetAnotherClassNotFoundException) {
                    try {
                        return ClassLoader.getSystemClassLoader().loadClass(valueClassName).getName();
                    }
                    catch (ClassNotFoundException e) {
                        return valueClassName;
                    }
                }
            }
        }
    }

    protected Class numericAttributeClass(String valueType) {
        if (valueType == null) {
            return null;
        }
        if ("b".equals(valueType)) {
            return Byte.class;
        }
        if ("s".equals(valueType)) {
            return Short.class;
        }
        if ("i".equals(valueType)) {
            return Integer.class;
        }
        if ("l".equals(valueType)) {
            return Long.class;
        }
        if ("f".equals(valueType)) {
            return Float.class;
        }
        if ("d".equals(valueType)) {
            return Double.class;
        }
        if ("B".equals(valueType)) {
            return BigDecimal.class;
        }
        if ("c".equals(valueType)) {
            return Boolean.class;
        }
        return null;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public URL getModelUrl() {
        return this.modelUrl;
    }

    public Iterator modelNames() {
        return this.entityClassIndex.keySet().iterator();
    }

    public List modelNamesAsList() {
        return new ArrayList(this.entityClassIndex.keySet());
    }

    public Map getPrototypeAttributeMapFor(String aPrototypeAttributeName) {
        Map aMap;
        if (this.prototypeValues == null) {
            Map eoPrototypesEntityMap = this.entityPListMap("EOPrototypes");
            if (eoPrototypesEntityMap == null) {
                this.prototypeValues = Collections.EMPTY_MAP;
            } else {
                List eoPrototypeAttributes = (List)eoPrototypesEntityMap.get("attributes");
                this.prototypeValues = new HashMap();
                for (Map attrMap : eoPrototypeAttributes) {
                    String attrName = (String)attrMap.get("name");
                    HashMap prototypeAttrMap = new HashMap();
                    this.prototypeValues.put(attrName, prototypeAttrMap);
                    prototypeAttrMap.put("name", attrMap.get("name"));
                    prototypeAttrMap.put("prototypeName", attrMap.get("prototypeName"));
                    prototypeAttrMap.put("columnName", attrMap.get("columnName"));
                    prototypeAttrMap.put("valueClassName", attrMap.get("valueClassName"));
                    prototypeAttrMap.put("width", attrMap.get("width"));
                    prototypeAttrMap.put("allowsNull", attrMap.get("allowsNull"));
                    prototypeAttrMap.put("scale", attrMap.get("scale"));
                    prototypeAttrMap.put("valueType", attrMap.get("valueType"));
                }
            }
        }
        if (null == (aMap = (Map)this.prototypeValues.get(aPrototypeAttributeName))) {
            aMap = Collections.EMPTY_MAP;
        }
        return aMap;
    }

    public Map entityPListMap(String entityName) {
        return (Map)this.entityIndex.get(entityName);
    }

    public Iterator queryNames(String entityName) {
        Map queryPlist = (Map)this.entityQueryIndex.get(entityName);
        if (queryPlist == null || queryPlist.isEmpty()) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        return queryPlist.keySet().iterator();
    }

    public Map queryPListMap(String entityName, String queryName) {
        Map queryPlist = (Map)this.entityQueryIndex.get(entityName);
        if (queryPlist == null || queryPlist.isEmpty()) {
            return null;
        }
        return (Map)queryPlist.get(queryName);
    }

    public String entityClass(String entityName, boolean getClientClass) {
        if (getClientClass) {
            return (String)this.entityClientClassIndex.get(entityName);
        }
        return (String)this.entityClassIndex.get(entityName);
    }

    protected Map loadModelIndex() throws Exception {
        InputStream indexIn = this.openIndexStream();
        try {
            this.plistParser.ReInit(indexIn);
            Map map = (Map)this.plistParser.propertyList();
            return map;
        }
        finally {
            indexIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadEntityIndex(String entityName) throws Exception {
        InputStream entIn = this.openEntityStream(entityName);
        try {
            this.plistParser.ReInit(entIn);
            Map map = (Map)this.plistParser.propertyList();
            return map;
        }
        finally {
            entIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadQueryIndex(String entityName) throws Exception {
        InputStream queryIn = null;
        try {
            queryIn = this.openQueryStream(entityName);
        }
        catch (IOException ioex) {
            return Collections.EMPTY_MAP;
        }
        try {
            this.plistParser.ReInit(queryIn);
            Map map = (Map)this.plistParser.propertyList();
            return map;
        }
        finally {
            queryIn.close();
        }
    }

    protected String findModelName(String path) {
        int i2;
        int i1;
        int i;
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        int n = i = (i1 = path.lastIndexOf("/")) > (i2 = path.lastIndexOf("\\")) ? i1 : i2;
        if (i >= 0) {
            path = path.substring(i + 1);
        }
        if (path.endsWith(".eomodeld")) {
            path = path.substring(0, path.length() - ".eomodeld".length());
        }
        return path;
    }

    protected URL findModelUrl(String path) {
        URL base;
        if (!path.endsWith(".eomodeld")) {
            path = path + ".eomodeld";
        }
        if ((base = locator.findDirectoryResource(path)) == null) {
            throw new IllegalArgumentException("Can't find EOModel: " + path);
        }
        return base;
    }

    protected InputStream openIndexStream() throws Exception {
        return new URL(this.modelUrl, "index.eomodeld").openStream();
    }

    protected InputStream openEntityStream(String entityName) throws Exception {
        return new URL(this.modelUrl, entityName + ".plist").openStream();
    }

    protected InputStream openQueryStream(String entityName) throws Exception {
        return new URL(this.modelUrl, entityName + ".fspec").openStream();
    }

    static {
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(false);
        locator.setSkipHomeDirectory(true);
        locator.setSkipAbsolutePath(false);
    }
}

