/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableBufferAllocator;
import org.apache.cassandra.utils.memory.MemtableCleaner;
import org.apache.cassandra.utils.memory.MemtablePool;

public class HeapPool
extends MemtablePool {
    public HeapPool(long maxOnHeapMemory, float cleanupThreshold, MemtableCleaner cleaner) {
        super(maxOnHeapMemory, 0L, cleanupThreshold, cleaner);
    }

    @Override
    public boolean needToCopyOnHeap() {
        return false;
    }

    @Override
    public MemtableAllocator newAllocator() {
        return new Allocator(this);
    }

    private static class Allocator
    extends MemtableBufferAllocator {
        Allocator(HeapPool pool) {
            super(pool.onHeap.newAllocator(), pool.offHeap.newAllocator());
        }

        @Override
        public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
            super.onHeap().allocate(size, opGroup);
            return ByteBuffer.allocate(size);
        }
    }
}

