/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getsstables", description="Print the sstable filenames that own the key")
public class GetSSTables
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table> <key>", description="The keyspace, the table, and the key")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() == 3 ? 1 : 0) != 0, (Object)"getsstables requires ks, cf and key args");
        String ks = this.args.get(0);
        String cf = this.args.get(1);
        String key = this.args.get(2);
        List<String> sstables = probe.getSSTables(ks, cf, key);
        for (String sstable : sstables) {
            probe.output().out.println(sstable);
        }
    }
}

