/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RemoteSyncTask;
import org.apache.cassandra.repair.RepairJob;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.RepairResult;
import org.apache.cassandra.repair.RepairSessionResult;
import org.apache.cassandra.repair.SystemDistributedKeyspace;
import org.apache.cassandra.repair.ValidationTask;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTrees;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairSession
extends AbstractFuture<RepairSessionResult>
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private static Logger logger = LoggerFactory.getLogger(RepairSession.class);
    public final UUID parentRepairSession;
    private final UUID id;
    public final String keyspace;
    private final String[] cfnames;
    public final RepairParallelism parallelismDegree;
    public final Collection<Range<Token>> ranges;
    public final Set<InetAddress> endpoints;
    public final long repairedAt;
    private final AtomicBoolean isFailed = new AtomicBoolean(false);
    private final ConcurrentMap<Pair<RepairJobDesc, InetAddress>, ValidationTask> validating = new ConcurrentHashMap<Pair<RepairJobDesc, InetAddress>, ValidationTask>();
    private final ConcurrentMap<Pair<RepairJobDesc, NodePair>, RemoteSyncTask> syncingTasks = new ConcurrentHashMap<Pair<RepairJobDesc, NodePair>, RemoteSyncTask>();
    public final ListeningExecutorService taskExecutor;
    private volatile boolean terminated = false;

    public RepairSession(UUID parentRepairSession, UUID id, Collection<Range<Token>> ranges, String keyspace, RepairParallelism parallelismDegree, Set<InetAddress> endpoints, long repairedAt, String ... cfnames) {
        assert (cfnames.length > 0) : "Repairing no column families seems pointless, doesn't it";
        this.parentRepairSession = parentRepairSession;
        this.id = id;
        this.parallelismDegree = parallelismDegree;
        this.keyspace = keyspace;
        this.cfnames = cfnames;
        this.ranges = ranges;
        this.endpoints = endpoints;
        this.repairedAt = repairedAt;
        this.taskExecutor = MoreExecutors.listeningDecorator((ExecutorService)this.createExecutor());
    }

    @VisibleForTesting
    protected DebuggableThreadPoolExecutor createExecutor() {
        return DebuggableThreadPoolExecutor.createCachedThreadpoolWithMaxSize("RepairJobTask");
    }

    public UUID getId() {
        return this.id;
    }

    public Collection<Range<Token>> getRanges() {
        return this.ranges;
    }

    public void waitForValidation(Pair<RepairJobDesc, InetAddress> key, ValidationTask task) {
        this.validating.put(key, task);
    }

    public void waitForSync(Pair<RepairJobDesc, NodePair> key, RemoteSyncTask task) {
        this.syncingTasks.put(key, task);
    }

    public void validationComplete(RepairJobDesc desc, InetAddress endpoint, MerkleTrees trees) {
        ValidationTask task = (ValidationTask)this.validating.remove(Pair.create(desc, endpoint));
        if (task == null) {
            assert (this.terminated);
            return;
        }
        String message = String.format("Received merkle tree for %s from %s", desc.columnFamily, endpoint);
        logger.info("[repair #{}] {}", (Object)this.getId(), (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        task.treesReceived(trees);
    }

    public void syncComplete(RepairJobDesc desc, NodePair nodes, boolean success) {
        RemoteSyncTask task = (RemoteSyncTask)this.syncingTasks.get(Pair.create(desc, nodes));
        if (task == null) {
            assert (this.terminated);
            return;
        }
        logger.debug(String.format("[repair #%s] Repair completed between %s and %s on %s", this.getId(), nodes.endpoint1, nodes.endpoint2, desc.columnFamily));
        task.syncComplete(success);
    }

    @VisibleForTesting
    Map<Pair<RepairJobDesc, NodePair>, RemoteSyncTask> getSyncingTasks() {
        return Collections.unmodifiableMap(this.syncingTasks);
    }

    private String repairedNodes() {
        StringBuilder sb = new StringBuilder();
        sb.append(FBUtilities.getBroadcastAddress());
        for (InetAddress ep : this.endpoints) {
            sb.append(", ").append(ep);
        }
        return sb.toString();
    }

    public void start(ListeningExecutorService executor) {
        if (this.terminated) {
            return;
        }
        logger.info(String.format("[repair #%s] new session: will sync %s on range %s for %s.%s", this.getId(), this.repairedNodes(), this.ranges, this.keyspace, Arrays.toString(this.cfnames)));
        Tracing.traceRepair("Syncing range {}", this.ranges);
        SystemDistributedKeyspace.startRepairs(this.getId(), this.parentRepairSession, this.keyspace, this.cfnames, this.ranges, this.endpoints);
        if (this.endpoints.isEmpty()) {
            String message = String.format("No neighbors to repair with on range %s: session completed", this.ranges);
            logger.info("[repair #{}] {}", (Object)this.getId(), (Object)message);
            Tracing.traceRepair(message, new Object[0]);
            this.set(new RepairSessionResult(this.id, this.keyspace, this.ranges, Lists.newArrayList()));
            SystemDistributedKeyspace.failRepairs(this.getId(), this.keyspace, this.cfnames, new RuntimeException(message));
            return;
        }
        for (InetAddress endpoint : this.endpoints) {
            if (FailureDetector.instance.isAlive(endpoint)) continue;
            String message = String.format("Cannot proceed on repair because a neighbor (%s) is dead: session failed", endpoint);
            logger.error("[repair #{}] {}", (Object)this.getId(), (Object)message);
            IOException e = new IOException(message);
            this.setException(e);
            SystemDistributedKeyspace.failRepairs(this.getId(), this.keyspace, this.cfnames, e);
            return;
        }
        ArrayList<RepairJob> jobs = new ArrayList<RepairJob>(this.cfnames.length);
        for (String cfname : this.cfnames) {
            RepairJob job = new RepairJob(this, cfname);
            executor.execute((Runnable)job);
            jobs.add(job);
        }
        Futures.addCallback((ListenableFuture)Futures.allAsList(jobs), (FutureCallback)new FutureCallback<List<RepairResult>>(){

            public void onSuccess(List<RepairResult> results) {
                logger.info("[repair #{}] {}", (Object)RepairSession.this.getId(), (Object)"Session completed successfully");
                Tracing.traceRepair("Completed sync of range {}", RepairSession.this.ranges);
                RepairSession.this.set(new RepairSessionResult(RepairSession.this.id, RepairSession.this.keyspace, RepairSession.this.ranges, results));
                RepairSession.this.taskExecutor.shutdown();
                RepairSession.this.terminate();
            }

            public void onFailure(Throwable t) {
                logger.error(String.format("[repair #%s] Session completed with the following error", RepairSession.this.getId()), t);
                Tracing.traceRepair("Session completed with the following error: {}", t);
                RepairSession.this.forceShutdown(t);
            }
        });
    }

    public void terminate() {
        this.terminated = true;
        this.validating.clear();
        this.syncingTasks.clear();
    }

    public void forceShutdown(Throwable reason) {
        this.setException(reason);
        for (ValidationTask validationTask : this.validating.values()) {
            validationTask.cancel(true);
        }
        for (RemoteSyncTask syncTask : this.syncingTasks.values()) {
            syncTask.cancel(true);
        }
        this.taskExecutor.shutdownNow();
        this.terminate();
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState epState) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        if (!this.endpoints.contains(endpoint)) {
            return;
        }
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold()) {
            return;
        }
        if (!this.isFailed.compareAndSet(false, true)) {
            return;
        }
        IOException exception = new IOException(String.format("Endpoint %s died", endpoint));
        logger.error(String.format("[repair #%s] session completed with the following error", this.getId()), (Throwable)exception);
        this.forceShutdown(exception);
    }
}

