/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FunctionName {
    private static final Set<Character> DISALLOWED_CHARACTERS = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('['), Character.valueOf(']'))));
    public final String keyspace;
    public final String name;

    public static FunctionName nativeFunction(String name) {
        return new FunctionName("system", name);
    }

    public static boolean isNameValid(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!DISALLOWED_CHARACTERS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public FunctionName(String keyspace, String name) {
        assert (name != null) : "Name parameter must not be null";
        this.keyspace = keyspace;
        this.name = name;
    }

    public FunctionName asNativeFunction() {
        return FunctionName.nativeFunction(this.name);
    }

    public boolean hasKeyspace() {
        return this.keyspace != null;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyspace, this.name});
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FunctionName)) {
            return false;
        }
        FunctionName that = (FunctionName)o;
        return Objects.equal((Object)this.keyspace, (Object)that.keyspace) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public final boolean equalsNativeFunction(FunctionName nativeFunction) {
        assert (nativeFunction.keyspace.equals("system"));
        if (this.hasKeyspace() && !this.keyspace.equals("system")) {
            return false;
        }
        return Objects.equal((Object)this.name, (Object)nativeFunction.name);
    }

    public String toString() {
        return this.keyspace == null ? this.name : this.keyspace + "." + this.name;
    }
}

