/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.fhir.api.FhirTransaction;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.fhir.api.FhirTransaction
 */
public enum FhirTransactionApiMethod implements ApiMethod {

    WITH_BUNDLE(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "withBundle",
        arg("bundle", org.hl7.fhir.instance.model.api.IBaseBundle.class),
        arg("extraParameters", java.util.Map.class)),

    WITH_BUNDLE_1(
        String.class,
        "withBundle",
        arg("stringBundle", String.class),
        arg("extraParameters", java.util.Map.class)),

    WITH_RESOURCES(
        java.util.List.class,
        "withResources",
        arg("resources", java.util.List.class),
        arg("extraParameters", java.util.Map.class));

    private final ApiMethod apiMethod;

    FhirTransactionApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(FhirTransaction.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
