/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupFluent;

public class APIGroupBuilder
extends APIGroupFluent<APIGroupBuilder>
implements VisitableBuilder<APIGroup, APIGroupBuilder> {
    APIGroupFluent<?> fluent;
    Boolean validationEnabled;

    public APIGroupBuilder() {
        this(false);
    }

    public APIGroupBuilder(Boolean validationEnabled) {
        this(new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance) {
        this(fluent, instance, false);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance, Boolean validationEnabled) {
        this.fluent = fluent;
        APIGroup aPIGroup = instance = instance != null ? instance : new APIGroup();
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withName(instance.getName());
            fluent.withPreferredVersion(instance.getPreferredVersion());
            fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
            fluent.withVersions(instance.getVersions());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withName(instance.getName());
            fluent.withPreferredVersion(instance.getPreferredVersion());
            fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
            fluent.withVersions(instance.getVersions());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public APIGroupBuilder(APIGroup instance) {
        this(instance, (Boolean)false);
    }

    public APIGroupBuilder(APIGroup instance, Boolean validationEnabled) {
        this.fluent = this;
        APIGroup aPIGroup = instance = instance != null ? instance : new APIGroup();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withPreferredVersion(instance.getPreferredVersion());
            this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
            this.withVersions(instance.getVersions());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withPreferredVersion(instance.getPreferredVersion());
            this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
            this.withVersions(instance.getVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIGroup build() {
        APIGroup buildable = new APIGroup(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.buildPreferredVersion(), this.fluent.buildServerAddressByClientCIDRs(), this.fluent.buildVersions());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

