/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.kubernetes;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.brooklyn.container.location.kubernetes.KubernetesCerts;
import org.apache.brooklyn.container.location.kubernetes.KubernetesClientRegistry;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocationConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientRegistryImpl
implements KubernetesClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesClientRegistryImpl.class);
    public static final KubernetesClientRegistryImpl INSTANCE = new KubernetesClientRegistryImpl();

    @Override
    public KubernetesClient getKubernetesClient(ConfigBag conf) {
        Duration clientTimeout;
        ConfigBuilder configBuilder = null;
        String configFile = (String)conf.get(KubernetesLocationConfig.KUBECONFIG);
        if (Strings.isNonBlank((CharSequence)configFile)) {
            try {
                Path configPath = Paths.get(configFile, new String[0]);
                Config clientConfig = Config.fromKubeconfig((String)new String(Files.readAllBytes(configPath)));
                configBuilder = new ConfigBuilder(clientConfig);
                LOG.debug("Master URL: {}", (Object)clientConfig.getMasterUrl());
            }
            catch (IOException e) {
                Exceptions.propagate((Throwable)e);
            }
        } else {
            String token;
            String password;
            String username;
            URL url;
            configBuilder = new ConfigBuilder();
            String masterUrl = (String)Preconditions.checkNotNull((Object)conf.get(KubernetesLocationConfig.MASTER_URL), (Object)"master url must not be null");
            Boolean trustCerts = (Boolean)conf.get(KubernetesLocationConfig.TRUST_CERTS);
            try {
                url = new URL(masterUrl);
            }
            catch (MalformedURLException e) {
                throw Throwables.propagate((Throwable)e);
            }
            ((ConfigBuilder)configBuilder.withMasterUrl(masterUrl)).withTrustCerts((trustCerts != null ? trustCerts : Boolean.FALSE).booleanValue());
            if (url.getProtocol().equals("https")) {
                KubernetesCerts certs = new KubernetesCerts(conf);
                if (certs.caCertData.isPresent()) {
                    configBuilder.withCaCertData(this.toBase64Encoding((String)certs.caCertData.get()));
                }
                if (certs.clientCertData.isPresent()) {
                    configBuilder.withClientCertData(this.toBase64Encoding((String)certs.clientCertData.get()));
                }
                if (certs.clientKeyData.isPresent()) {
                    configBuilder.withClientKeyData(this.toBase64Encoding((String)certs.clientKeyData.get()));
                }
                if (certs.clientKeyAlgo.isPresent()) {
                    configBuilder.withClientKeyAlgo((String)certs.clientKeyAlgo.get());
                }
                if (certs.clientKeyPassphrase.isPresent()) {
                    configBuilder.withClientKeyPassphrase((String)certs.clientKeyPassphrase.get());
                }
            }
            if (Strings.isNonBlank((CharSequence)(username = (String)conf.get(KubernetesLocationConfig.ACCESS_IDENTITY)))) {
                configBuilder.withUsername(username);
            }
            if (Strings.isNonBlank((CharSequence)(password = (String)conf.get(KubernetesLocationConfig.ACCESS_CREDENTIAL)))) {
                configBuilder.withPassword(password);
            }
            if (Strings.isNonBlank((CharSequence)(token = (String)conf.get(KubernetesLocationConfig.OAUTH_TOKEN)))) {
                configBuilder.withOauthToken(token);
            }
        }
        if (!(clientTimeout = (Duration)conf.get(KubernetesLocationConfig.CLIENT_TIMEOUT)).isPositive()) {
            throw new IllegalArgumentException("Kubernetes client timeout should be a positive duration: " + clientTimeout.toString());
        }
        configBuilder.withConnectionTimeout((int)clientTimeout.toMilliseconds());
        configBuilder.withRequestTimeout((int)clientTimeout.toMilliseconds());
        Duration actionTimeout = (Duration)conf.get(KubernetesLocationConfig.ACTION_TIMEOUT);
        if (!actionTimeout.isPositive()) {
            throw new IllegalArgumentException("Kubernetes action timeout should be a positive duration: " + actionTimeout.toString());
        }
        configBuilder.withScaleTimeout(actionTimeout.toMilliseconds());
        return new DefaultKubernetesClient(configBuilder.build());
    }

    protected String toBase64Encoding(String val) {
        return BaseEncoding.base64().encode(val.getBytes());
    }

    protected String getRelativeFile(String file, Path folder) {
        if (Strings.isBlank((CharSequence)file)) {
            return null;
        }
        Path path = Paths.get(file, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            path = folder.resolve(file);
        }
        return path.toString();
    }
}

