/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.net.ReachableSocketFinder;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.domain.Container;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.ec2.compute.functions.WindowsLoginCredentialsFromEncryptedData;
import org.jclouds.ec2.domain.PasswordData;
import org.jclouds.ec2.features.WindowsApi;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Predicates2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsUtil.class);

    private JcloudsUtil() {
    }

    public static String getFirstReachableAddress(NodeMetadata node, Duration timeout) {
        return JcloudsUtil.getFirstReachableAddress(node, timeout, (Predicate<? super HostAndPort>)Networking.isReachablePredicate());
    }

    public static String getFirstReachableAddress(NodeMetadata node, Duration timeout, Predicate<? super HostAndPort> socketTester) {
        Iterable<HostAndPort> addresses = JcloudsUtil.getReachableAddresses(node, timeout, socketTester);
        HostAndPort address = (HostAndPort)Iterables.getFirst(addresses, null);
        if (address != null) {
            return address.getHost();
        }
        throw new IllegalStateException("No reachable IPs for " + node + "; check whether the node is reachable and whether it meets the requirements of the HostAndPort tester: " + socketTester);
    }

    public static Iterable<HostAndPort> getReachableAddresses(NodeMetadata node, Duration timeout, Predicate<? super HostAndPort> socketTester) {
        int port = node.getLoginPort();
        return JcloudsUtil.getReachableAddresses(Iterables.concat((Iterable)node.getPublicAddresses(), (Iterable)node.getPrivateAddresses()), port, timeout, socketTester);
    }

    public static Iterable<HostAndPort> getReachableAddresses(Iterable<String> hosts, final int port, Duration timeout, Predicate<? super HostAndPort> socketTester) {
        FluentIterable sockets = FluentIterable.from(hosts).transform((Function)new Function<String, HostAndPort>(){

            public HostAndPort apply(String input) {
                return HostAndPort.fromParts((String)input, (int)port);
            }
        });
        return JcloudsUtil.getReachableAddresses((Iterable<HostAndPort>)sockets, timeout, socketTester);
    }

    public static Iterable<HostAndPort> getReachableAddresses(Iterable<HostAndPort> sockets, Duration timeout, Predicate<? super HostAndPort> socketTester) {
        ReachableSocketFinder finder = new ReachableSocketFinder(socketTester);
        return finder.findOpenSocketsOnNode(sockets, timeout);
    }

    public static String waitForPasswordOnAws(ComputeService computeService, NodeMetadata node, long timeout, TimeUnit timeUnit) throws TimeoutException {
        ComputeServiceContext computeServiceContext = computeService.getContext();
        AWSEC2Api ec2Client = (AWSEC2Api)computeServiceContext.unwrapApi(AWSEC2Api.class);
        final WindowsApi client = (WindowsApi)ec2Client.getWindowsApi().get();
        final String region = node.getLocation().getParent().getId();
        Predicate<String> passwordReady = new Predicate<String>(){

            public boolean apply(String s) {
                if (Strings.isNullOrEmpty((String)s)) {
                    return false;
                }
                PasswordData data = client.getPasswordDataInRegion(region, s);
                if (data == null) {
                    return false;
                }
                return !Strings.isNullOrEmpty((String)data.getPasswordData());
            }
        };
        LOG.info("Waiting for password, for " + node.getProviderId() + ":" + node.getId());
        Predicate passwordReadyRetryable = Predicates2.retry((Predicate)passwordReady, (long)timeUnit.toMillis(timeout), (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean ready = passwordReadyRetryable.apply((Object)node.getProviderId());
        if (!ready) {
            throw new TimeoutException("Password not available for " + node + " in region " + region + " after " + timeout + " " + timeUnit.name());
        }
        PasswordDataAndPrivateKey dataAndKey = new PasswordDataAndPrivateKey(client.getPasswordDataInRegion(region, node.getProviderId()), node.getCredentials().getPrivateKey());
        WindowsLoginCredentialsFromEncryptedData f = (WindowsLoginCredentialsFromEncryptedData)computeServiceContext.utils().injector().getInstance(WindowsLoginCredentialsFromEncryptedData.class);
        LoginCredentials credentials = f.apply(dataAndKey);
        return credentials.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Integer> dockerPortMappingsFor(JcloudsLocation docker, String containerId) {
        try (ComputeServiceContext context = null;){
            Properties properties = new Properties();
            properties.setProperty("jclouds.trust-all-certs", Boolean.toString(true));
            properties.setProperty("jclouds.relax-hostname", Boolean.toString(true));
            context = (ComputeServiceContext)ContextBuilder.newBuilder((String)"docker").endpoint(docker.getEndpoint()).credentials(docker.getIdentity(), docker.getCredential()).overrides(properties).modules((Iterable)ImmutableSet.of((Object)new SLF4JLoggingModule(), (Object)new SshjSshClientModule())).build(ComputeServiceContext.class);
            DockerApi api = (DockerApi)context.unwrapApi(DockerApi.class);
            Container container = api.getContainerApi().inspectContainer(containerId);
            LinkedHashMap portMappings = Maps.newLinkedHashMap();
            Map ports = container.networkSettings().ports();
            if (ports == null) {
                ports = ImmutableMap.of();
            }
            LOG.debug("Docker will forward these ports {}", (Object)ports);
            for (Map.Entry entrySet : ports.entrySet()) {
                String containerPort = (String)Iterables.get((Iterable)Splitter.on((String)"/").split((CharSequence)entrySet.getKey()), (int)0);
                String hostPort = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)((Iterable)entrySet.getValue()), (Function)new Function<Map<String, String>, String>(){

                    public String apply(Map<String, String> hostIpAndPort) {
                        return hostIpAndPort.get("HostPort");
                    }
                }));
                portMappings.put(Integer.parseInt(containerPort), Integer.parseInt(hostPort));
            }
            LinkedHashMap linkedHashMap = portMappings;
            return linkedHashMap;
        }
    }
}

