/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.internal.BrooklynLoggingCategories;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class ScheduledTask
extends BasicTask<Object> {
    final Callable<Task<?>> taskFactory;
    protected Duration delay;
    protected Duration period = null;
    protected Integer maxIterations = null;
    protected boolean cancelOnException = true;
    protected ExecutionContext executionContext;
    protected int runCount = 0;
    protected Task<?> recentRun;
    protected Task<?> nextRun;
    Class<? extends Exception> lastThrownType;

    public int getRunCount() {
        return this.runCount;
    }

    public ScheduledFuture<?> getNextScheduled() {
        return (ScheduledFuture)this.internalFuture;
    }

    public ScheduledTask(Callable<Task<?>> taskFactory) {
        this((Map<?, ?>)MutableMap.of(), taskFactory);
    }

    @Deprecated
    public ScheduledTask(Task<?> task) {
        this((Map<?, ?>)MutableMap.of(), task);
    }

    @Deprecated
    public ScheduledTask(Map<?, ?> flags, final Task<?> task) {
        this(flags, new Callable<Task<?>>(){

            @Override
            public Task<?> call() throws Exception {
                return task;
            }
        });
    }

    public ScheduledTask(Map<?, ?> flags, Callable<Task<?>> taskFactory) {
        super(flags);
        this.taskFactory = taskFactory;
        this.delay = Duration.of((Object)JavaGroovyEquivalents.elvis(flags.remove("delay"), (Object)0));
        this.period = Duration.of((Object)JavaGroovyEquivalents.elvis(flags.remove("period"), null));
        this.maxIterations = (Integer)JavaGroovyEquivalents.elvis(flags.remove("maxIterations"), null);
        Object cancelFlag = flags.remove("cancelOnException");
        this.cancelOnException = cancelFlag == null || Boolean.TRUE.equals(cancelFlag);
    }

    public static Builder builder(Callable<Task<?>> val) {
        return new Builder(val);
    }

    public static String prefixScheduledName(String taskName) {
        return "scheduled:[" + taskName + "]";
    }

    public ScheduledTask delay(Duration d) {
        this.delay = d;
        return this;
    }

    public ScheduledTask delay(long val) {
        return this.delay(Duration.millis((Number)val));
    }

    public ScheduledTask period(Duration d) {
        this.period = d;
        return this;
    }

    public ScheduledTask period(long val) {
        return this.period(Duration.millis((Number)val));
    }

    public ScheduledTask maxIterations(int val) {
        this.maxIterations = val;
        return this;
    }

    public ScheduledTask cancelOnException(boolean cancel) {
        this.cancelOnException = cancel;
        return this;
    }

    public Callable<Task<?>> getTaskFactory() {
        return this.taskFactory;
    }

    public Task<?> newTask() {
        try {
            return this.taskFactory.call();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected void computeStatusStringActive(int verbosity, BasicTask.StatusStringData data) {
        if (Strings.isNonBlank((CharSequence)data.mainShortSummary)) {
            data.appendToSummary("; scheduled task");
        } else {
            data.setSummary("Scheduler");
        }
        if (verbosity >= 1) {
            ScheduledFuture<?> nextScheduled;
            if (this.runCount > 0) {
                data.appendToSummary(", iteration " + (this.runCount + 1));
            }
            if (this.recentRun != null) {
                Duration start = Duration.sinceUtc((long)this.recentRun.getStartTimeUtc());
                data.appendToSummary(", last run " + start + " ago");
            }
            if ((nextScheduled = this.getNextScheduled()) != null) {
                Duration untilNext;
                if (nextScheduled.isDone() || nextScheduled.isCancelled()) {
                    data.appendToSummary(", not scheduled to run again");
                }
                if ((untilNext = Duration.millis((Number)nextScheduled.getDelay(TimeUnit.MILLISECONDS))).isPositive()) {
                    data.appendToSummary(", next in " + untilNext);
                } else {
                    data.appendToSummary(", next imminent");
                }
            } else {
                data.appendToSummary(", nothing scheduled");
            }
        }
    }

    @Override
    public boolean isDone(boolean andTaskNoLongerRunning) {
        boolean done;
        boolean bl = done = this.isCancelled() || this.maxIterations != null && this.maxIterations <= this.runCount || this.period == null && this.nextRun != null && this.nextRun.isDone();
        if (andTaskNoLongerRunning) {
            return done && super.isDone(true);
        }
        return done;
    }

    public synchronized void blockUntilFirstScheduleStarted() {
        do {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (this.recentRun != null) continue;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Throwables.propagate((Throwable)e);
            }
        } while (this.recentRun == null);
    }

    @Override
    public void blockUntilEnded() {
        while (!this.isDone()) {
            super.blockUntilEnded();
        }
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        this.blockUntilStarted();
        this.blockUntilFirstScheduleStarted();
        return JavaGroovyEquivalents.groovyTruth(this.recentRun) ? this.recentRun.get() : this.internalFuture.get();
    }

    @Override
    protected boolean doCancel(TaskInternal.TaskCancellationMode mode) {
        BrooklynLogging.log(BrooklynLoggingCategories.TASK_LIFECYCLE_LOG, BrooklynLogging.LoggingLevel.DEBUG, "Cancelling scheduled task " + this, new Object[0]);
        if (this.nextRun != null) {
            ((TaskInternal)this.nextRun).cancel(mode);
            try {
                ((TaskInternal)this.nextRun).getJob().call();
                this.nextRun = null;
            }
            catch (CancellationException cancellationException) {
            }
            catch (Exception e) {
                throw Exceptions.propagateAnnotated((String)("Error cancelling scheduled task " + this), (Throwable)e);
            }
        }
        return super.doCancel(mode);
    }

    @Beta
    public boolean blockUntilNextRunFinished(Duration timeout) {
        return Tasks.blockUntilInternalTasksEnded(this.nextRun, timeout);
    }

    public static class Builder {
        Callable<Task<?>> factory;
        String displayName;
        List<Object> tags = MutableList.of();
        Duration delay;
        Duration period;
        Integer maxInterations;
        boolean cancelOnException = true;
        Map<String, Object> flags = MutableMap.of();

        public Builder(Callable<Task<?>> val) {
            this.factory = val;
        }

        public ScheduledTask build() {
            return new ScheduledTask((Map<?, ?>)MutableMap.copyOf(this.flags).addIfNotNull((Object)"displayName", (Object)this.displayName).addIfNotNull((Object)"tags", this.tags.isEmpty() ? null : this.tags).addIfNotNull((Object)"delay", (Object)this.delay).addIfNotNull((Object)"period", (Object)this.period).addIfNotNull((Object)"maxIterations", (Object)this.maxInterations).addIfNotNull((Object)"cancelOnException", (Object)this.cancelOnException), this.factory);
        }

        public Builder displayName(String val) {
            this.displayName = val;
            return this;
        }

        public Builder tag(Object val) {
            if (val != null) {
                this.tags.add(val);
            }
            return this;
        }

        public Builder tagTransient() {
            return this.tag("TRANSIENT");
        }

        public Builder delay(Duration val) {
            this.delay = val;
            return this;
        }

        public Builder period(Duration val) {
            this.period = val;
            return this;
        }

        public Builder maxIterations(Integer val) {
            this.maxInterations = val;
            return this;
        }

        public Builder cancelOnException(boolean val) {
            this.cancelOnException = val;
            return this;
        }

        public Builder addFlags(Map<String, ?> val) {
            this.flags.putAll(val);
            return this;
        }
    }
}

