/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynEntityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynEntityUtils.class);

    public static String parseBlueprintYaml(Object yaml, String blueprintType) {
        String newBlueprint = null;
        if (yaml instanceof Map) {
            newBlueprint = BrooklynEntityUtils.toJson((Map)yaml);
        } else if (yaml instanceof String) {
            newBlueprint = (String)yaml;
        } else if (yaml != null) {
            throw new IllegalArgumentException("Map or string is required in blueprint YAML; not " + yaml.getClass() + " (" + yaml + ")");
        }
        if (blueprintType != null) {
            if (newBlueprint != null) {
                throw new IllegalArgumentException("Cannot take both blueprint type and blueprint YAML");
            }
            newBlueprint = "services: [ { type: " + blueprintType + " } ]";
        }
        if (newBlueprint == null) {
            throw new IllegalArgumentException("Either blueprint type or blueprint YAML is required");
        }
        return newBlueprint;
    }

    public static List<String> addChildrenToEntity(Entity entity, ConfigBag entityParams, String blueprint, Boolean autostart) {
        if (!entityParams.isEmpty()) {
            Map m = (Map)Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)blueprint));
            if (m.containsKey("brooklyn.config")) {
                Map cfg1 = (Map)m.get("brooklyn.config");
                MutableMap cfgMergeFlat = MutableMap.copyOf((Map)cfg1).add(entityParams.getAllConfig());
                if (cfgMergeFlat.size() < cfg1.size() + entityParams.size()) {
                    LOG.warn("Adding blueprint where same config key is supplied in blueprint and as parameters;preferring parameter (no merge), but behaviour may change. Recommended to use distinct keys.");
                }
                m.put("brooklyn.config", cfgMergeFlat);
                blueprint = BrooklynEntityUtils.toJson(m);
            } else if (BrooklynEntityUtils.isJsonNotYaml(blueprint)) {
                m.put("brooklyn.config", entityParams.getAllConfig());
                blueprint = BrooklynEntityUtils.toJson(m);
            } else {
                blueprint = blueprint + "\nbrooklyn.config: " + BrooklynEntityUtils.toJson(entityParams.getAllConfig());
            }
        }
        LOG.debug("Adding children to " + entity + ":\n" + blueprint);
        EntityManagementUtils.CreationResult<List<Entity>, List<String>> result = EntityManagementUtils.addChildren(entity, blueprint, autostart);
        LOG.debug("Added children to " + entity + ": " + result.get());
        return (List)result.task().getUnchecked();
    }

    private static String toJson(Map<?, ?> x) {
        return Jsonya.newInstance().add(x, new Object[0]).toString();
    }

    private static boolean isJsonNotYaml(String x) {
        return x.trim().startsWith("{");
    }
}

