/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Resizable;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.cloud.AvailabilityZoneExtension;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.group.AbstractGroupImpl;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.group.QuarantineGroup;
import org.apache.brooklyn.entity.group.RemovalStrategy;
import org.apache.brooklyn.entity.group.StopFailedRuntimeException;
import org.apache.brooklyn.entity.group.zoneaware.ProportionalZoneFailureDetector;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.Suppliers;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClusterImpl
extends AbstractGroupImpl
implements DynamicCluster {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicClusterImpl.class);
    private static final AttributeSensor<Supplier<Integer>> NEXT_CLUSTER_MEMBER_ID = Sensors.newSensor(new TypeToken<Supplier<Integer>>(){}, "next.cluster.member.id", "Returns the ID number of the next member to be added");
    private transient Semaphore childTaskSemaphore;
    private transient DynamicCluster.ZoneFailureDetector zoneFailureDetector;
    private volatile FunctionFeed clusterOneAndAllMembersUp;
    protected final Object mutex = new Object[0];
    @Deprecated
    private static final Function<Collection<Entity>, Entity> defaultRemovalStrategy;

    @Override
    public void init() {
        super.init();
        this.initialiseMemberId();
        this.initialiseTaskPermitSemaphore();
        this.initializeZoneFailureDetector();
        this.connectAllMembersUp();
    }

    @Override
    public void rebind() {
        super.rebind();
        this.initialiseTaskPermitSemaphore();
        this.initializeZoneFailureDetector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseMemberId() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.sensors().get(NEXT_CLUSTER_MEMBER_ID) == null) {
                this.sensors().set(NEXT_CLUSTER_MEMBER_ID, Suppliers.incrementing());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseTaskPermitSemaphore() {
        Object object = this.mutex;
        synchronized (object) {
            Integer maxChildTasks;
            if (this.getChildTaskSemaphore() == null && (maxChildTasks = (Integer)this.config().get(MAX_CONCURRENT_CHILD_COMMANDS)) != null && maxChildTasks > 0) {
                this.childTaskSemaphore = new Semaphore(maxChildTasks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeZoneFailureDetector() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.zoneFailureDetector == null && this.isAvailabilityZoneEnabled()) {
                this.zoneFailureDetector = (DynamicCluster.ZoneFailureDetector)this.config().get(ZONE_FAILURE_DETECTOR);
                if (this.zoneFailureDetector == null) {
                    this.zoneFailureDetector = new ProportionalZoneFailureDetector(2, Duration.ONE_HOUR, 0.9);
                }
            }
        }
    }

    private void connectAllMembersUp() {
        this.clusterOneAndAllMembersUp = FunctionFeed.builder().uniqueTag("one-and-all-members-up").entity(this).period(Duration.FIVE_SECONDS).poll(((FunctionPollConfig)new FunctionPollConfig(CLUSTER_ONE_AND_ALL_MEMBERS_UP).onException(Functions.constant((Object)Boolean.FALSE))).callable(new ClusterOneAndAllMembersUpCallable(this))).build(true);
    }

    @Override
    protected void initEnrichers() {
        if (this.config().getRaw(UP_QUORUM_CHECK).isAbsent() && (Integer)Preconditions.checkNotNull(this.getConfig(INITIAL_SIZE), (Object)"Cluster initial size overridden to be null. Must be set explicitly.") == 0) {
            this.config().set(UP_QUORUM_CHECK, QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty());
            this.sensors().set(ServiceStateLogic.SERVICE_NOT_UP_INDICATORS, MutableMap.of());
            this.sensors().set(SERVICE_UP, true);
        } else {
            this.sensors().set(SERVICE_UP, false);
        }
        super.initEnrichers();
        ServiceStateLogic.newEnricherFromChildrenUp().checkMembersOnly().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).addTo(this);
    }

    @Override
    public void setRemovalStrategy(Function<Collection<Entity>, Entity> val) {
        this.config().set(REMOVAL_STRATEGY, Preconditions.checkNotNull(val, (Object)"removalStrategy"));
    }

    protected Function<Collection<Entity>, Entity> getRemovalStrategy() {
        Function result = (Function)this.getConfig(REMOVAL_STRATEGY);
        return result != null ? result : new DefaultRemovalStrategy();
    }

    @Override
    public void setZonePlacementStrategy(DynamicCluster.NodePlacementStrategy val) {
        this.config().set(ZONE_PLACEMENT_STRATEGY, Preconditions.checkNotNull((Object)val, (Object)"zonePlacementStrategy"));
    }

    protected DynamicCluster.NodePlacementStrategy getZonePlacementStrategy() {
        return (DynamicCluster.NodePlacementStrategy)Preconditions.checkNotNull(this.getConfig(ZONE_PLACEMENT_STRATEGY), (Object)"zonePlacementStrategy config");
    }

    @Override
    public void setZoneFailureDetector(DynamicCluster.ZoneFailureDetector val) {
        this.config().set(ZONE_FAILURE_DETECTOR, Preconditions.checkNotNull((Object)val, (Object)"zoneFailureDetector"));
        this.zoneFailureDetector = val;
    }

    protected DynamicCluster.ZoneFailureDetector getZoneFailureDetector() {
        return (DynamicCluster.ZoneFailureDetector)Preconditions.checkNotNull((Object)this.zoneFailureDetector, (String)"zoneFailureDetector, isAvailabilityZoneEnabled=%s", (Object)this.isAvailabilityZoneEnabled());
    }

    protected EntitySpec<?> getFirstMemberSpec() {
        return (EntitySpec)this.getConfig(FIRST_MEMBER_SPEC);
    }

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC);
    }

    @Override
    public void setMemberSpec(EntitySpec<?> memberSpec) {
        this.setConfigEvenIfOwned(MEMBER_SPEC, memberSpec);
    }

    private Location getLocation(boolean required) {
        Collection<? extends Location> ll = Locations.getLocationsCheckingAncestors(this.getLocations(), this);
        if (ll.isEmpty()) {
            if (!required) {
                return null;
            }
            throw new IllegalStateException("No location available for " + this);
        }
        if (ll.size() > 1) {
            throw new IllegalStateException("Ambiguous location for " + this + "; expected one but had " + ll);
        }
        return (Location)Iterables.getOnlyElement(ll);
    }

    protected boolean isAvailabilityZoneEnabled() {
        return (Boolean)this.getConfig(ENABLE_AVAILABILITY_ZONES);
    }

    protected boolean isQuarantineEnabled() {
        return (Boolean)this.getConfig(QUARANTINE_FAILED_ENTITIES);
    }

    protected QuarantineGroup getQuarantineGroup() {
        return (QuarantineGroup)this.getAttribute(QUARANTINE_GROUP);
    }

    protected Predicate<? super Throwable> getQuarantineFilter() {
        Predicate result = (Predicate)this.getConfig(QUARANTINE_FILTER);
        if (result != null) {
            return result;
        }
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                return Exceptions.getFirstThrowableOfType((Throwable)input, NoMachinesAvailableException.class) == null;
            }
        };
    }

    protected int getInitialQuorumSize() {
        int initialSize = (Integer)this.getConfig(INITIAL_SIZE);
        int initialQuorumSize = (Integer)this.getConfig(INITIAL_QUORUM_SIZE);
        if (initialQuorumSize < 0) {
            initialQuorumSize = initialSize;
        }
        if (initialQuorumSize > initialSize) {
            LOG.warn("On start of cluster {}, misconfigured initial quorum size {} greater than initial size{}; using {}", new Object[]{initialQuorumSize, initialSize, initialSize});
            initialQuorumSize = initialSize;
        }
        return initialQuorumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Collection<? extends Location> locsO) {
        this.addLocations(locsO);
        Location loc = this.getLocation(false);
        EntitySpec spec = (EntitySpec)this.getConfig(MEMBER_SPEC);
        if (spec != null) {
            this.setDefaultDisplayName("Cluster of " + JavaClassNames.simpleClassName((Class)spec.getType()) + (loc != null ? " (" + loc + ")" : ""));
        }
        if (this.isAvailabilityZoneEnabled()) {
            if (loc == null) {
                throw new IllegalStateException("When using availability zones, a location must be specified on the cluster");
            }
            this.sensors().set(SUB_LOCATIONS, this.findSubLocations(loc));
        }
        ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this, START);
        try {
            this.doStart();
            DynamicTasks.waitForLast();
        }
        catch (Exception e) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this, START, (Object)("start failed with error: " + e));
            ServiceStateLogic.setExpectedStateRunningWithErrors(this);
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            this.waitForServiceUp();
        }
        finally {
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
        }
    }

    protected void doStart() {
        QuarantineGroup quarantineGroup;
        if (this.isQuarantineEnabled() && ((quarantineGroup = (QuarantineGroup)this.getAttribute(QUARANTINE_GROUP)) == null || !Entities.isManagedActive(quarantineGroup))) {
            quarantineGroup = (QuarantineGroup)this.addChild((EntitySpec)EntitySpec.create(QuarantineGroup.class).displayName("quarantine"));
            this.sensors().set(QUARANTINE_GROUP, quarantineGroup);
        }
        int initialSize = (Integer)this.getConfig(INITIAL_SIZE);
        int initialQuorumSize = this.getInitialQuorumSize();
        Exception internalError = null;
        try {
            this.resize(initialSize);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error resizing " + this + " to size " + initialSize + " (collecting and handling): " + e, (Throwable)e);
            internalError = e;
        }
        Iterable<Task<?>> failed = Tasks.failed(Tasks.children(Tasks.current()));
        boolean noFailed = Iterables.isEmpty(failed);
        boolean severalFailed = Iterables.size(failed) > 1;
        int currentSize = this.getCurrentSize();
        if (currentSize < initialQuorumSize) {
            String message = currentSize == 0 && !noFailed ? (severalFailed ? "All nodes in cluster " + this + " failed" : "Node in cluster " + this + " failed") : "On start of cluster " + this + ", failed to get to initial size of " + initialSize + "; size is " + this.getCurrentSize() + (initialQuorumSize != initialSize ? " (initial quorum size is " + initialQuorumSize + ")" : "");
            Throwable firstError = Tasks.getError((Task)Maybe.next(failed.iterator()).orNull());
            if (firstError == null && internalError != null) {
                firstError = internalError;
            }
            if (firstError != null) {
                message = severalFailed ? message + "; first failure is: " + Exceptions.collapseText((Throwable)firstError) : message + ": " + Exceptions.collapseText((Throwable)firstError);
            }
            throw new IllegalStateException(message, firstError);
        }
        if (currentSize < initialSize) {
            LOG.warn("On start of cluster {}, size {} reached initial minimum quorum size of {} but did not reach desired size {}; continuing", new Object[]{this, currentSize, initialQuorumSize, initialSize});
        }
        Iterator<Policy> iterator = this.policies().iterator();
        while (iterator.hasNext()) {
            Policy it = iterator.next();
            if (!it.isSuspended()) continue;
            it.resume();
        }
    }

    protected void waitForServiceUp() {
        Duration timeout = (Duration)this.getConfig(START_TIMEOUT);
        if (timeout != null) {
            this.waitForServiceUp(timeout);
        }
    }

    protected void waitForServiceUp(Duration duration) {
        Entities.waitForServiceUp(this, duration);
    }

    protected List<Location> findSubLocations(Location loc) {
        List<Location> subLocations;
        if (!loc.hasExtension(AvailabilityZoneExtension.class)) {
            throw new IllegalStateException("Availability zone extension not supported for location " + loc);
        }
        AvailabilityZoneExtension zoneExtension = (AvailabilityZoneExtension)loc.getExtension(AvailabilityZoneExtension.class);
        Collection zoneNames = (Collection)this.getConfig(AVAILABILITY_ZONE_NAMES);
        Integer numZones = (Integer)this.getConfig(NUM_AVAILABILITY_ZONES);
        if (zoneNames == null || zoneNames.isEmpty()) {
            if (numZones != null) {
                subLocations = zoneExtension.getSubLocations(numZones);
                Preconditions.checkArgument((numZones > 0 ? 1 : 0) != 0, (String)"numZones must be greater than zero: %s", (Object)numZones);
                if (numZones > subLocations.size()) {
                    throw new IllegalStateException("Number of required zones (" + numZones + ") not satisfied in " + loc + "; only " + subLocations.size() + " available: " + subLocations);
                }
            } else {
                subLocations = zoneExtension.getAllSubLocations();
            }
        } else {
            subLocations = zoneExtension.getSubLocationsByName((Predicate<? super String>)StringPredicates.equalToAny((Iterable)zoneNames), zoneNames.size());
            if (zoneNames.size() > subLocations.size()) {
                throw new IllegalStateException("Number of required zones (" + zoneNames.size() + " - " + zoneNames + ") not satisfied in " + loc + "; only " + subLocations.size() + " available: " + subLocations);
            }
        }
        LOG.info("Returning {} sub-locations: {}", (Object)subLocations.size(), (Object)Iterables.toString(subLocations));
        return subLocations;
    }

    @Override
    public void stop() {
        ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPING);
        try {
            Iterator<Policy> iterator = this.policies().iterator();
            while (iterator.hasNext()) {
                Policy it = iterator.next();
                it.suspend();
            }
            int size = this.getCurrentSize();
            if (size > 0) {
                this.shrink(-size);
            }
            this.resize(0);
            StartableMethods.stop(this);
            ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.stopClusterAndMembersFeed();
        }
    }

    protected void stopClusterAndMembersFeed() {
        if (this.clusterOneAndAllMembersUp != null) {
            this.clusterOneAndAllMembersUp.stop();
        }
    }

    @Override
    public void restart() {
        String mode = (String)this.getConfig(RESTART_MODE);
        if (mode == null) {
            throw new UnsupportedOperationException("Restart not supported for this cluster: " + RESTART_MODE.getName() + " is not configured.");
        }
        if ("off".equalsIgnoreCase(mode)) {
            throw new UnsupportedOperationException("Restart not supported for this cluster.");
        }
        if ("sequential".equalsIgnoreCase(mode)) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
            DynamicTasks.queue(Effectors.invocationSequential(Startable.RESTART, null, Iterables.filter(this.getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(Startable.class), EntityPredicates.isManaged()))));
        } else if ("parallel".equalsIgnoreCase(mode)) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
            for (Entity member : Iterables.filter(this.getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(Startable.class), EntityPredicates.isManaged()))) {
                DynamicTasks.queue(this.newThrottledEffectorTask(member, Startable.RESTART, Collections.emptyMap()));
            }
        } else {
            throw new IllegalArgumentException("Unknown " + RESTART_MODE.getName() + " '" + mode + "'");
        }
        DynamicTasks.waitForLast();
        ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer resize(Integer desiredSize) {
        Object object = this.mutex;
        synchronized (object) {
            int originalSize = this.getCurrentSize();
            int delta = desiredSize - originalSize;
            if (delta != 0) {
                LOG.info("Resize {} from {} to {}", new Object[]{this, originalSize, desiredSize});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Resize no-op {} from {} to {}", new Object[]{this, originalSize, desiredSize});
            }
            try {
                this.resizeByDelta(delta);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                NoMachinesAvailableException nmae = (NoMachinesAvailableException)Exceptions.getFirstThrowableOfType((Throwable)e, NoMachinesAvailableException.class);
                if (nmae != null) {
                    throw new Resizable.InsufficientCapacityException("Failed to resize", e);
                }
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return this.getCurrentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String replaceMember(String memberId) {
        Entity member = this.getEntityManager().getEntity(memberId);
        LOG.info("In {}, replacing member {} ({})", new Object[]{this, memberId, member});
        if (member == null) {
            throw new NoSuchElementException("In " + this + ", entity " + memberId + " cannot be resolved, so not replacing");
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.getMembers().contains(member)) {
                throw new NoSuchElementException("In " + this + ", entity " + member + " is not a member so not replacing");
            }
            Location memberLoc = null;
            if (this.isAvailabilityZoneEnabled()) {
                List<Location> subLocations = this.findSubLocations(this.getLocation(true));
                Collection actualMemberLocs = member.getLocations();
                boolean foundMatch = false;
                Iterator iter = actualMemberLocs.iterator();
                while (!foundMatch && iter.hasNext()) {
                    Location actualMemberLoc;
                    Location contenderMemberLoc = actualMemberLoc = (Location)iter.next();
                    do {
                        if (subLocations.contains(contenderMemberLoc)) {
                            memberLoc = contenderMemberLoc;
                            foundMatch = true;
                            LOG.debug("In {} replacing member {} ({}), inferred its sub-location is {}", new Object[]{this, memberId, member, memberLoc});
                        }
                        contenderMemberLoc = contenderMemberLoc.getParent();
                    } while (!foundMatch && contenderMemberLoc != null);
                }
                if (!foundMatch) {
                    if (actualMemberLocs.isEmpty()) {
                        memberLoc = subLocations.get(0);
                        LOG.warn("In {} replacing member {} ({}), has no locations; falling back to first availability zone: {}", new Object[]{this, memberId, member, memberLoc});
                    } else {
                        memberLoc = (Location)Iterables.tryFind((Iterable)actualMemberLocs, (Predicate)Predicates.instanceOf(MachineProvisioningLocation.class)).or(Iterables.getFirst((Iterable)actualMemberLocs, null));
                        LOG.warn("In {} replacing member {} ({}), could not find matching sub-location; falling back to its actual location: {}", new Object[]{this, memberId, member, memberLoc});
                    }
                } else if (memberLoc == null) {
                    throw new IllegalStateException("Unexpected condition! cluster=" + this + "; member=" + member + "; actualMemberLocs=" + actualMemberLocs);
                }
            } else {
                memberLoc = this.getLocation(false);
            }
            Entity replacement = this.replaceMember(member, memberLoc, (Map<?, ?>)ImmutableMap.of());
            return replacement.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity replaceMember(Entity member, @Nullable Location memberLoc, Map<?, ?> extraFlags) {
        Object object = this.mutex;
        synchronized (object) {
            ReferenceWithError<Optional<Entity>> added = this.addInSingleLocation(memberLoc, extraFlags);
            if (!((Optional)added.getWithoutError()).isPresent()) {
                String msg = String.format("In %s, failed to grow, to replace %s; not removing", this, member);
                if (added.hasError()) {
                    throw new IllegalStateException(msg, added.getError());
                }
                throw new IllegalStateException(msg);
            }
            try {
                this.stopAndRemoveNode(member);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new StopFailedRuntimeException("replaceMember failed to stop and remove old member " + member.getId(), e);
            }
            return (Entity)((Optional)added.getWithError()).get();
        }
    }

    protected Multimap<Location, Entity> getMembersByLocation() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Entity member : this.getMembers()) {
            Collection memberLocs = member.getLocations();
            Location memberLoc = (Location)Iterables.getFirst((Iterable)memberLocs, null);
            if (memberLoc == null) continue;
            result.put((Object)memberLoc, (Object)member);
        }
        return result;
    }

    protected List<Location> getNonFailedSubLocations() {
        ArrayList result = Lists.newArrayList();
        LinkedHashSet failed = Sets.newLinkedHashSet();
        List<Location> subLocations = this.findSubLocations(this.getLocation(true));
        Set oldFailedSubLocations = (Set)this.getAttribute(FAILED_SUB_LOCATIONS);
        if (oldFailedSubLocations == null) {
            oldFailedSubLocations = ImmutableSet.of();
        }
        for (Location subLocation : subLocations) {
            if (this.getZoneFailureDetector().hasFailed(subLocation)) {
                failed.add(subLocation);
                continue;
            }
            result.add(subLocation);
        }
        Sets.SetView newlyFailed = Sets.difference((Set)failed, (Set)oldFailedSubLocations);
        Sets.SetView newlyRecovered = Sets.difference((Set)oldFailedSubLocations, (Set)failed);
        this.sensors().set(FAILED_SUB_LOCATIONS, failed);
        this.sensors().set(SUB_LOCATIONS, result);
        if (newlyFailed.size() > 0) {
            LOG.warn("Detected probably zone failures for {}: {}", (Object)this, (Object)newlyFailed);
        }
        if (newlyRecovered.size() > 0) {
            LOG.warn("Detected probably zone recoveries for {}: {}", (Object)this, (Object)newlyRecovered);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entity> resizeByDelta(int delta) {
        Object object = this.mutex;
        synchronized (object) {
            if (delta > 0) {
                return this.grow(delta);
            }
            if (delta < 0) {
                return this.shrink(delta);
            }
            return ImmutableList.of();
        }
    }

    protected Collection<Entity> grow(int delta) {
        List<Object> chosenLocations;
        EntitySpec<?> memberSpec;
        boolean memberSpecHasLocation;
        Preconditions.checkArgument((delta > 0 ? 1 : 0) != 0, (Object)"Must call grow with positive delta.");
        Integer maxSize = (Integer)this.config().get(MAX_SIZE);
        if (maxSize != null) {
            Integer currentSize = this.getCurrentSize();
            int desiredSize = currentSize + delta;
            if (currentSize >= maxSize) {
                throw new Resizable.InsufficientCapacityException("Current cluster size " + currentSize + " already at maximum permitted");
            }
            if (desiredSize > maxSize) {
                int allowedDelta = maxSize - currentSize;
                LOG.warn("Desired cluster size " + desiredSize + " exceeds maximum size of " + maxSize + "; will only grow by " + allowedDelta + " instead of " + delta + " for " + this);
                delta = allowedDelta;
            }
        }
        boolean bl = memberSpecHasLocation = (memberSpec = this.getMemberSpec()) != null && (!memberSpec.getLocationSpecs().isEmpty() || !memberSpec.getLocations().isEmpty());
        if (memberSpecHasLocation) {
            if (this.isAvailabilityZoneEnabled()) {
                LOG.warn("Cluster {} has availability-zone enabled, but memberSpec overrides location with {}; using memberSpec's location; availability-zone behaviour will not apply", (Object)this, (Object)("" + memberSpec.getLocationSpecs() + "+" + memberSpec.getLocations()));
            }
            chosenLocations = Collections.nCopies(delta, null);
        } else if (this.isAvailabilityZoneEnabled()) {
            List<Location> subLocations = this.getNonFailedSubLocations();
            Multimap<Location, Entity> membersByLocation = this.getMembersByLocation();
            chosenLocations = this.getZonePlacementStrategy().locationsForAdditions(membersByLocation, subLocations, delta);
            if (chosenLocations.size() != delta) {
                throw new IllegalStateException("Node placement strategy chose " + Iterables.size(chosenLocations) + ", when expected delta " + delta + " in " + this);
            }
        } else {
            chosenLocations = Collections.nCopies(delta, this.getLocation(false));
        }
        ReferenceWithError<Collection<Entity>> result = this.addInEachLocation((Iterable<Location>)chosenLocations, (Map<?, ?>)ImmutableMap.of());
        return (Collection)result.getWithError();
    }

    protected Collection<Entity> shrink(int delta) {
        Preconditions.checkArgument((delta < 0 ? 1 : 0) != 0, (Object)"Must call shrink with negative delta.");
        int size = this.getCurrentSize();
        if (-delta > size) {
            LOG.warn("Call to shrink " + this + " by " + delta + " when size is " + size + "; amending");
            delta = -size;
        }
        if (delta == 0) {
            return ImmutableList.of();
        }
        List<Entity> removedEntities = this.pickAndRemoveMembers(delta * -1);
        Iterable removedStartables = Iterables.filter(removedEntities, Startable.class);
        ImmutableList.Builder tasks = ImmutableList.builder();
        for (Entity member : removedStartables) {
            tasks.add(this.newThrottledEffectorTask(member, Startable.STOP, Collections.emptyMap()));
        }
        try {
            DynamicTasks.get(Tasks.parallel(tasks.build()));
            List<Entity> list = removedEntities;
            return list;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            for (Entity removedEntity : removedEntities) {
                this.discardNode(removedEntity);
            }
        }
    }

    protected ReferenceWithError<Optional<Entity>> addInSingleLocation(@Nullable Location location, Map<?, ?> flags) {
        Optional result;
        ReferenceWithError<Collection<Entity>> added = this.addInEachLocation(Arrays.asList(location), flags);
        Optional optional = result = Iterables.isEmpty((Iterable)((Iterable)added.getWithoutError())) ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement((Iterable)((Iterable)added.get())));
        if (!added.hasError()) {
            return ReferenceWithError.newInstanceWithoutError((Object)result);
        }
        if (added.masksErrorIfPresent()) {
            return ReferenceWithError.newInstanceMaskingError((Object)result, (Throwable)added.getError());
        }
        return ReferenceWithError.newInstanceThrowingError((Object)result, (Throwable)added.getError());
    }

    protected ReferenceWithError<Collection<Entity>> addInEachLocation(Iterable<Location> locations, Map<?, ?> flags) {
        ArrayList addedEntities = Lists.newArrayList();
        LinkedHashMap addedEntityLocations = Maps.newLinkedHashMap();
        LinkedHashMap tasks = Maps.newLinkedHashMap();
        for (Location loc : locations) {
            Entity entity = this.addNode(loc, flags);
            addedEntities.add(entity);
            addedEntityLocations.put(entity, loc);
            if (!(entity instanceof Startable)) continue;
            boolean bl = entity.equals(AbstractGroup.getFirst(this));
            ImmutableMap args = ImmutableMap.of((Object)"locations", (Object)MutableList.builder().addIfNotNull((Object)loc).buildImmutable());
            Task<?> task = this.newThrottledEffectorTask(entity, (Effector)Startable.START, (Map<?, ?>)args, bl);
            tasks.put(entity, task);
        }
        Task<List<?>> parallel = Tasks.parallel("starting " + tasks.size() + " node" + Strings.s((int)tasks.size()) + " (parallel)", tasks.values());
        TaskTags.markInessential(parallel);
        DynamicTasks.queueIfPossible(parallel).orSubmitAsync(this);
        Map<Entity, Throwable> errors = this.waitForTasksOnEntityStart(tasks);
        if (this.isAvailabilityZoneEnabled()) {
            for (Map.Entry entry : addedEntityLocations.entrySet()) {
                Entity entity = (Entity)entry.getKey();
                Location loc = (Location)entry.getValue();
                Throwable err = errors.get(entity);
                if (err == null) {
                    this.getZoneFailureDetector().onStartupSuccess(loc, entity);
                    continue;
                }
                this.getZoneFailureDetector().onStartupFailure(loc, entity, err);
            }
        }
        MutableList result = MutableList.builder().addAll((Iterable)addedEntities).removeAll(errors.keySet()).build();
        if (!errors.isEmpty()) {
            if (this.isQuarantineEnabled()) {
                this.quarantineFailedNodes(errors);
            } else {
                this.cleanupFailedNodes(errors.keySet());
            }
            return ReferenceWithError.newInstanceMaskingError((Object)result, (Throwable)Exceptions.create(errors.values()));
        }
        return ReferenceWithError.newInstanceWithoutError((Object)result);
    }

    protected void quarantineFailedNodes(Map<Entity, Throwable> failedEntities) {
        for (Map.Entry<Entity, Throwable> entry : failedEntities.entrySet()) {
            Entity entity = entry.getKey();
            Throwable cause = entry.getValue();
            if (cause == null || this.getQuarantineFilter().apply((Object)cause)) {
                this.sensors().emit(ENTITY_QUARANTINED, entity);
                this.getQuarantineGroup().addMember(entity);
                this.removeMember(entity);
                continue;
            }
            LOG.info("Cluster {} discarding failed node {}, rather than quarantining", (Object)this, (Object)entity);
            this.discardNode(entity);
        }
    }

    protected void cleanupFailedNodes(Collection<Entity> failedEntities) {
        for (Entity entity : failedEntities) {
            this.discardNode(entity);
        }
    }

    protected Map<Entity, Throwable> waitForTasksOnEntityStart(Map<? extends Entity, ? extends Task<?>> tasks) {
        LinkedHashMap errors = Maps.newLinkedHashMap();
        for (Map.Entry<Entity, Task<?>> entry : tasks.entrySet()) {
            Entity entity = entry.getKey();
            Task<?> task = entry.getValue();
            try {
                task.get();
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable t) {
                Throwable interesting = Exceptions.getFirstInteresting((Throwable)t);
                LOG.error("Cluster " + this + " failed to start entity " + entity + " (removing): " + interesting, interesting);
                LOG.debug("Trace for: Cluster " + this + " failed to start entity " + entity + " (removing): " + t, t);
                errors.put(entity, t);
            }
        }
        return errors;
    }

    @Override
    public boolean removeChild(Entity child) {
        boolean changed = super.removeChild(child);
        if (changed) {
            this.removeMember(child);
        }
        return changed;
    }

    protected Map<?, ?> getCustomChildFlags() {
        return (Map)this.getConfig(CUSTOM_CHILD_FLAGS);
    }

    @Override
    public Entity addNode(@Nullable Location loc, Map<?, ?> extraFlags) {
        this.initialiseMemberId();
        MutableMap createFlags = MutableMap.builder().putAll(this.getCustomChildFlags()).putAll(extraFlags).put((Object)CLUSTER_MEMBER_ID, this.sensors().get(NEXT_CLUSTER_MEMBER_ID).get()).build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating and adding a node to cluster {}({}) with properties {}", new Object[]{this, this.getId(), Sanitizer.sanitize(createFlags)});
        }
        Entity entity = this.createNode(loc, (Map<?, ?>)createFlags);
        entity.sensors().set(CLUSTER_MEMBER, (Object)true);
        entity.sensors().set(CLUSTER, (Object)this);
        Entities.manage(entity);
        this.addMember(entity);
        return entity;
    }

    protected Entity createNode(@Nullable Location loc, Map<?, ?> flags) {
        EntitySpec<?> memberSpec = null;
        if (this.getMembers().isEmpty()) {
            memberSpec = this.getFirstMemberSpec();
        }
        if (memberSpec == null) {
            memberSpec = this.getMemberSpec();
        }
        if (memberSpec == null) {
            throw new IllegalStateException("No member spec supplied for dynamic cluster " + this);
        }
        EntitySpec specConfigured = (EntitySpec)EntitySpec.create(memberSpec).configure(flags);
        if (loc != null) {
            specConfigured.location(loc);
        }
        return this.addChild(specConfigured);
    }

    protected List<Entity> pickAndRemoveMembers(int delta) {
        if (delta == 0) {
            return Lists.newArrayList();
        }
        if (delta == 1 && !this.isAvailabilityZoneEnabled()) {
            Maybe<Entity> member = this.tryPickAndRemoveMember();
            return member.isPresent() ? ImmutableList.of((Object)member.get()) : ImmutableList.of();
        }
        Preconditions.checkState((this.getMembers().size() > 0 ? 1 : 0) != 0, (Object)("Attempt to remove a node (delta " + delta + ") when members is empty, from cluster " + this));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing a node from {}", (Object)this);
        }
        if (this.isAvailabilityZoneEnabled()) {
            Multimap<Location, Entity> membersByLocation = this.getMembersByLocation();
            List<Entity> entities = this.getZonePlacementStrategy().entitiesToRemove(membersByLocation, delta);
            Preconditions.checkState((entities.size() == delta ? 1 : 0) != 0, (String)"Incorrect num entity chosen for removal from %s (%s when expected %s)", (Object)this.getId(), (Object)entities.size(), (Object)delta);
            for (Entity entity : entities) {
                this.removeMember(entity);
            }
            return entities;
        }
        ArrayList entities = Lists.newArrayList();
        for (int i = 0; i < delta; ++i) {
            Maybe<Entity> member = this.tryPickAndRemoveMember();
            if (!member.isPresent()) continue;
            entities.add(member.get());
        }
        return entities;
    }

    private Maybe<Entity> tryPickAndRemoveMember() {
        assert (!this.isAvailabilityZoneEnabled()) : "should instead call pickAndRemoveMembers(int) if using availability zones";
        Collection<Entity> members = this.getMembers();
        if (members.isEmpty()) {
            return Maybe.absent();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing a node from {}", (Object)this);
        }
        Entity entity = (Entity)this.getRemovalStrategy().apply(members);
        Preconditions.checkNotNull((Object)entity, (Object)("No entity chosen for removal from " + this.getId()));
        this.removeMember(entity);
        return Maybe.of((Object)entity);
    }

    protected void discardNode(Entity entity) {
        this.removeMember(entity);
        try {
            Entities.unmanage(entity);
        }
        catch (IllegalStateException e) {
            LOG.debug("Exception during removing member of cluster " + this + ", unmanaging node " + entity + ". The node is probably already unmanaged.", (Throwable)e);
        }
    }

    protected void stopAndRemoveNode(Entity member) {
        this.removeMember(member);
        try {
            if (member instanceof Startable) {
                Task task = this.newThrottledEffectorTask(member, Startable.STOP, Collections.emptyMap());
                DynamicTasks.get(task);
            }
        }
        finally {
            Entities.unmanage(member);
        }
    }

    @Nullable
    protected Semaphore getChildTaskSemaphore() {
        return this.childTaskSemaphore;
    }

    protected <T> Task<?> newThrottledEffectorTask(Entity target, Effector<T> effector, Map<?, ?> arguments) {
        return this.newThrottledEffectorTask(target, effector, arguments, false);
    }

    protected <T> Task<?> newThrottledEffectorTask(Entity target, Effector<T> effector, Map<?, ?> arguments, boolean isPrivileged) {
        Task<List<?>> toSubmit;
        Task<List<?>> effectorTask = Effectors.invocation(target, effector, arguments).asTask();
        if (this.getChildTaskSemaphore() != null) {
            AtomicBoolean permitObtained = new AtomicBoolean();
            String description = "Waiting for permit to run " + effector.getName() + " on " + target;
            ObtainPermit obtain = new ObtainPermit(this.getChildTaskSemaphore(), description, permitObtained);
            if (isPrivileged) {
                obtain.run();
                toSubmit = effectorTask;
            } else {
                Task obtainMutex = Tasks.builder().description(description).body(new ObtainPermit(this.getChildTaskSemaphore(), description, permitObtained)).build();
                toSubmit = Tasks.sequential("Waiting for permit then running " + effector.getName() + " on " + target, new TaskAdaptable[]{obtainMutex, effectorTask});
            }
            toSubmit.addListener((Runnable)new ReleasePermit(this.getChildTaskSemaphore(), permitObtained), r -> r.run());
        } else {
            toSubmit = effectorTask;
        }
        return toSubmit;
    }

    static {
        TypeCoercions.registerAdapter(String.class, DynamicCluster.NodePlacementStrategy.class, new Function<String, DynamicCluster.NodePlacementStrategy>(){

            public DynamicCluster.NodePlacementStrategy apply(String input) {
                ClassLoader classLoader = DynamicCluster.NodePlacementStrategy.class.getClassLoader();
                Maybe strategy = Reflections.invokeConstructorFromArgs((ClassLoader)classLoader, DynamicCluster.NodePlacementStrategy.class, (String)input, (Object[])new Object[0]);
                if (strategy.isPresent()) {
                    return (DynamicCluster.NodePlacementStrategy)strategy.get();
                }
                throw new IllegalStateException("Failed to create NodePlacementStrategy " + input);
            }
        });
        TypeCoercions.registerAdapter(String.class, DynamicCluster.ZoneFailureDetector.class, new Function<String, DynamicCluster.ZoneFailureDetector>(){

            public DynamicCluster.ZoneFailureDetector apply(String input) {
                ClassLoader classLoader = DynamicCluster.ZoneFailureDetector.class.getClassLoader();
                Maybe detector = Reflections.invokeConstructorFromArgs((ClassLoader)classLoader, DynamicCluster.ZoneFailureDetector.class, (String)input, (Object[])new Object[0]);
                if (detector.isPresent()) {
                    return (DynamicCluster.ZoneFailureDetector)detector.get();
                }
                throw new IllegalStateException("Failed to create ZoneFailureDetector " + input);
            }
        });
        RendererHints.register(FIRST, RendererHints.namedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register(CLUSTER, RendererHints.namedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        defaultRemovalStrategy = new Function<Collection<Entity>, Entity>(){

            public Entity apply(Collection<Entity> contenders) {
                return null;
            }
        };
    }

    private static class ReleasePermit
    implements Runnable {
        private final Semaphore permit;
        private final AtomicBoolean wasPermitObtained;

        private ReleasePermit(Semaphore permit, AtomicBoolean wasPermitObtained) {
            this.permit = permit;
            this.wasPermitObtained = wasPermitObtained;
        }

        @Override
        public void run() {
            if (this.wasPermitObtained.get()) {
                LOG.debug("{} releasing permit from {}", (Object)this, (Object)this.permit);
                this.permit.release();
            } else {
                LOG.debug("{} not releasing a permit from {} because it appears one was never obtained", (Object)this, (Object)this.permit);
            }
        }
    }

    private static class ObtainPermit
    implements Runnable {
        private final Semaphore permit;
        private final String description;
        private final AtomicBoolean hasObtainedPermit;

        private ObtainPermit(Semaphore permit, String description, AtomicBoolean hasObtainedPermit) {
            this.permit = permit;
            this.description = description;
            this.hasObtainedPermit = hasObtainedPermit;
        }

        @Override
        public void run() {
            String oldDetails = Tasks.setBlockingDetails(this.description);
            LOG.debug("{} acquiring permit from {}", (Object)this, (Object)this.permit);
            try {
                this.permit.acquire();
                this.hasObtainedPermit.set(true);
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                Tasks.setBlockingDetails(oldDetails);
            }
        }
    }

    private static class ClusterOneAndAllMembersUpCallable
    implements Callable<Boolean> {
        private final Group cluster;

        public ClusterOneAndAllMembersUpCallable(Group cluster) {
            this.cluster = cluster;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.cluster.getMembers().isEmpty()) {
                return false;
            }
            if (Lifecycle.RUNNING != this.cluster.sensors().get(DynamicCluster.SERVICE_STATE_ACTUAL)) {
                return false;
            }
            for (Entity member : this.cluster.getMembers()) {
                if (Boolean.TRUE.equals(member.sensors().get(Startable.SERVICE_UP))) continue;
                return false;
            }
            return true;
        }
    }

    @Deprecated
    private static class NextClusterMemberIdSupplier
    implements Supplier<Integer> {
        private AtomicInteger nextId = new AtomicInteger(0);

        private NextClusterMemberIdSupplier() {
        }

        public Integer get() {
            return this.nextId.getAndIncrement();
        }
    }

    public static class DefaultRemovalStrategy
    extends RemovalStrategy {
        @Nullable
        public Entity apply(@Nullable Collection<Entity> contenders) {
            int largestClusterMemberId = -1;
            long newestTime = 0L;
            Entity newest = null;
            for (Entity contender : contenders) {
                boolean newer;
                Integer contenderClusterMemberId = (Integer)contender.config().get(DynamicCluster.CLUSTER_MEMBER_ID);
                long contenderCreationTime = contender.getCreationTime();
                boolean bl = newer = contenderClusterMemberId != null && contenderClusterMemberId > largestClusterMemberId || contenderCreationTime > newestTime;
                if ((!(contender instanceof Startable) || !newer) && (newest instanceof Startable || !(contender instanceof Startable) && !newer)) continue;
                newest = contender;
                if (contenderClusterMemberId != null) {
                    largestClusterMemberId = contenderClusterMemberId;
                }
                newestTime = contenderCreationTime;
            }
            return newest;
        }
    }
}

