/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import java.io.InputStream;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.docker.domain.Exec;
import org.jclouds.docker.domain.ExecCreateParams;
import org.jclouds.docker.domain.ExecInspect;
import org.jclouds.docker.domain.ExecStartParams;
import org.jclouds.docker.domain.Info;
import org.jclouds.docker.domain.Version;
import org.jclouds.docker.options.BuildOptions;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
@Path(value="/v{jclouds.api-version}")
public interface MiscApi {
    @Named(value="version")
    @GET
    @Path(value="/version")
    public Version getVersion();

    @Named(value="info")
    @GET
    @Path(value="/info")
    public Info getInfo();

    @Named(value="image:build")
    @POST
    @Path(value="/build")
    @Headers(keys={"Content-Type", "Connection"}, values={"application/tar", "close"})
    public InputStream build(Payload var1);

    @Named(value="image:build")
    @POST
    @Path(value="/build")
    @Headers(keys={"Content-Type", "Connection"}, values={"application/tar", "close"})
    public InputStream build(Payload var1, BuildOptions var2);

    @Named(value="container:exec")
    @POST
    @Path(value="/containers/{id}/exec")
    public Exec execCreate(@PathParam(value="id") String var1, @BinderParam(value=BindToJsonPayload.class) ExecCreateParams var2);

    @Named(value="exec:start")
    @POST
    @Path(value="/exec/{id}/start")
    public InputStream execStart(@PathParam(value="id") String var1, @BinderParam(value=BindToJsonPayload.class) ExecStartParams var2);

    @Named(value="exec:inspect")
    @GET
    @Path(value="/exec/{id}/json")
    public ExecInspect execInspect(@PathParam(value="id") String var1);
}

