/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.InsertCommandMessage;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.WriteCommandProtocol;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import java.util.List;

class InsertCommandProtocol
extends WriteCommandProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.insert");
    private final List<InsertRequest> insertRequests;

    public InsertCommandProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> insertRequests) {
        super(namespace, ordered, writeConcern);
        this.insertRequests = insertRequests;
    }

    @Override
    public BulkWriteResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Inserting %d documents into namespace %s on connection [%s] to server %s", this.insertRequests.size(), this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        BulkWriteResult writeResult = super.execute(connection);
        LOGGER.debug("Insert completed");
        return writeResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<BulkWriteResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously inserting %d documents into namespace %s on connection [%s] to server %s", this.insertRequests.size(), this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<BulkWriteResult>(){

                @Override
                public void onResult(BulkWriteResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous insert completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.INSERT;
    }

    @Override
    protected InsertCommandMessage createRequestMessage(MessageSettings messageSettings) {
        return new InsertCommandMessage(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.insertRequests, messageSettings);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

