/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.WriteConcern;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectionString {
    private static final String PREFIX = "mongodb://";
    private static final String UTF_8 = "UTF-8";
    private static final Logger LOGGER = Loggers.getLogger("uri");
    private final MongoCredential credentials;
    private final List<String> hosts;
    private final String database;
    private final String collection;
    private final String uri;
    private ReadPreference readPreference;
    private WriteConcern writeConcern;
    private Integer minConnectionPoolSize;
    private Integer maxConnectionPoolSize;
    private Integer threadsAllowedToBlockForConnectionMultiplier;
    private Integer maxWaitTime;
    private Integer maxConnectionIdleTime;
    private Integer maxConnectionLifeTime;
    private Integer connectTimeout;
    private Integer socketTimeout;
    private Boolean sslEnabled;
    private String requiredReplicaSetName;
    private static final Set<String> GENERAL_OPTIONS_KEYS = new HashSet<String>();
    private static final Set<String> AUTH_KEYS = new HashSet<String>();
    private static final Set<String> READ_PREFERENCE_KEYS = new HashSet<String>();
    private static final Set<String> WRITE_CONCERN_KEYS = new HashSet<String>();
    private static final Set<String> ALL_KEYS = new HashSet<String>();

    public ConnectionString(String uri) {
        try {
            String optionsPart;
            String nsPart;
            String serverPart;
            if (!uri.startsWith(PREFIX)) {
                throw new IllegalArgumentException("uri needs to start with mongodb://");
            }
            this.uri = uri;
            String unprefixedURI = uri.substring(PREFIX.length());
            String userName = null;
            char[] password = null;
            int idx = unprefixedURI.lastIndexOf("/");
            if (idx < 0) {
                if (unprefixedURI.contains("?")) {
                    throw new IllegalArgumentException("URI contains options without trailing slash");
                }
                serverPart = unprefixedURI;
                nsPart = null;
                optionsPart = "";
            } else {
                serverPart = unprefixedURI.substring(0, idx);
                nsPart = unprefixedURI.substring(idx + 1);
                if ((idx = nsPart.indexOf("?")) >= 0) {
                    optionsPart = nsPart.substring(idx + 1);
                    nsPart = nsPart.substring(0, idx);
                } else {
                    optionsPart = "";
                }
            }
            LinkedList all = new LinkedList();
            idx = serverPart.indexOf("@");
            if (idx > 0) {
                String authPart = serverPart.substring(0, idx);
                serverPart = serverPart.substring(idx + 1);
                idx = authPart.indexOf(":");
                if (idx == -1) {
                    userName = URLDecoder.decode(authPart, UTF_8);
                } else {
                    userName = URLDecoder.decode(authPart.substring(0, idx), UTF_8);
                    password = URLDecoder.decode(authPart.substring(idx + 1), UTF_8).toCharArray();
                }
            }
            Collections.addAll(all, serverPart.split(","));
            Collections.sort(all);
            this.hosts = Collections.unmodifiableList(all);
            if (nsPart != null && !nsPart.isEmpty()) {
                idx = nsPart.indexOf(".");
                if (idx < 0) {
                    this.database = nsPart;
                    this.collection = null;
                } else {
                    this.database = nsPart.substring(0, idx);
                    this.collection = nsPart.substring(idx + 1);
                }
            } else {
                this.database = null;
                this.collection = null;
            }
            Map<String, List<String>> optionsMap = this.parseOptions(optionsPart);
            this.translateOptions(optionsMap);
            this.credentials = this.createCredentials(optionsMap, userName, password);
            this.warnOnUnsupportedOptions(optionsMap);
        }
        catch (UnsupportedEncodingException e) {
            throw new MongoInternalException("This should not happen", e);
        }
    }

    private void warnOnUnsupportedOptions(Map<String, List<String>> optionsMap) {
        for (String key : optionsMap.keySet()) {
            if (ALL_KEYS.contains(key) || !LOGGER.isWarnEnabled()) continue;
            LOGGER.warn(String.format("Unsupported option '%s' on URI '%s'.", key, this.uri));
        }
    }

    private void translateOptions(Map<String, List<String>> optionsMap) {
        for (String key : GENERAL_OPTIONS_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            if (key.equals("maxpoolsize")) {
                this.maxConnectionPoolSize = Integer.parseInt(value);
                continue;
            }
            if (key.equals("minpoolsize")) {
                this.minConnectionPoolSize = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxidletimems")) {
                this.maxConnectionIdleTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxlifetimems")) {
                this.maxConnectionLifeTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("waitqueuemultiple")) {
                this.threadsAllowedToBlockForConnectionMultiplier = Integer.parseInt(value);
                continue;
            }
            if (key.equals("waitqueuetimeoutms")) {
                this.maxWaitTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("connecttimeoutms")) {
                this.connectTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("sockettimeoutms")) {
                this.socketTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ssl") && this.parseBoolean(value)) {
                this.sslEnabled = true;
                continue;
            }
            if (!key.equals("replicaset")) continue;
            this.requiredReplicaSetName = value;
        }
        this.writeConcern = this.createWriteConcern(optionsMap);
        this.readPreference = this.createReadPreference(optionsMap);
    }

    private WriteConcern createWriteConcern(Map<String, List<String>> optionsMap) {
        Boolean safe = null;
        String w = null;
        int wTimeout = 0;
        boolean fsync = false;
        boolean journal = false;
        for (String key : WRITE_CONCERN_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            if (key.equals("safe")) {
                safe = this.parseBoolean(value);
                continue;
            }
            if (key.equals("w")) {
                w = value;
                continue;
            }
            if (key.equals("wtimeoutms")) {
                wTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("fsync")) {
                fsync = this.parseBoolean(value);
                continue;
            }
            if (!key.equals("j")) continue;
            journal = this.parseBoolean(value);
        }
        return this.buildWriteConcern(safe, w, wTimeout, fsync, journal);
    }

    private ReadPreference createReadPreference(Map<String, List<String>> optionsMap) {
        String readPreferenceType = null;
        ArrayList<TagSet> tagSetList = new ArrayList<TagSet>();
        for (String key : READ_PREFERENCE_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            if (key.equals("readpreference")) {
                readPreferenceType = value;
                continue;
            }
            if (!key.equals("readpreferencetags")) continue;
            for (String cur : optionsMap.get(key)) {
                TagSet tagSet = this.getTags(cur.trim());
                tagSetList.add(tagSet);
            }
        }
        return this.buildReadPreference(readPreferenceType, tagSetList);
    }

    private MongoCredential createCredentials(Map<String, List<String>> optionsMap, String userName, char[] password) {
        MongoCredential credential;
        if (userName == null) {
            return null;
        }
        AuthenticationMechanism mechanism = null;
        String authSource = this.database == null ? "admin" : this.database;
        String gssapiServiceName = null;
        String authMechanismProperties = null;
        for (String key : AUTH_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            if (key.equals("authmechanism")) {
                mechanism = AuthenticationMechanism.fromMechanismName(value);
                continue;
            }
            if (key.equals("authsource")) {
                authSource = value;
                continue;
            }
            if (key.equals("gssapiservicename")) {
                gssapiServiceName = value;
                continue;
            }
            if (!key.endsWith("authmechanismproperties")) continue;
            authMechanismProperties = value;
        }
        if (mechanism == AuthenticationMechanism.GSSAPI) {
            credential = MongoCredential.createGSSAPICredential(userName);
            if (gssapiServiceName != null) {
                credential = credential.withMechanismProperty("SERVICE_NAME", gssapiServiceName);
            }
        } else if (mechanism == AuthenticationMechanism.PLAIN) {
            credential = MongoCredential.createPlainCredential(userName, authSource, password);
        } else if (mechanism == AuthenticationMechanism.MONGODB_CR) {
            credential = MongoCredential.createMongoCRCredential(userName, authSource, password);
        } else if (mechanism == AuthenticationMechanism.MONGODB_X509) {
            credential = MongoCredential.createMongoX509Credential(userName);
        } else if (mechanism == AuthenticationMechanism.SCRAM_SHA_1) {
            credential = MongoCredential.createScramSha1Credential(userName, authSource, password);
        } else if (mechanism == null) {
            credential = MongoCredential.createCredential(userName, authSource, password);
        } else {
            throw new UnsupportedOperationException("Unsupported authentication mechanism in the URI: " + (Object)((Object)mechanism));
        }
        if (authMechanismProperties != null) {
            for (String part : authMechanismProperties.split(",")) {
                String[] mechanismPropertyKeyValue = part.split(":");
                if (mechanismPropertyKeyValue.length != 2) {
                    throw new IllegalArgumentException("Bad authMechanismProperties: " + authMechanismProperties);
                }
                String key = mechanismPropertyKeyValue[0].trim().toLowerCase();
                String value = mechanismPropertyKeyValue[1].trim();
                credential = key.equals("canonicalize_host_name") ? credential.withMechanismProperty(key, Boolean.valueOf(value)) : credential.withMechanismProperty(key, value);
            }
        }
        return credential;
    }

    private String getLastValue(Map<String, List<String>> optionsMap, String key) {
        List<String> valueList = optionsMap.get(key);
        if (valueList == null) {
            return null;
        }
        return valueList.get(valueList.size() - 1);
    }

    private Map<String, List<String>> parseOptions(String optionsPart) {
        HashMap<String, List<String>> optionsMap = new HashMap<String, List<String>>();
        for (String part : optionsPart.split("&|;")) {
            int idx = part.indexOf("=");
            if (idx < 0) continue;
            String key = part.substring(0, idx).toLowerCase();
            String value = part.substring(idx + 1);
            ArrayList<String> valueList = (ArrayList<String>)optionsMap.get(key);
            if (valueList == null) {
                valueList = new ArrayList<String>(1);
            }
            valueList.add(value);
            optionsMap.put(key, valueList);
        }
        if (optionsMap.containsKey("wtimeout") && !optionsMap.containsKey("wtimeoutms")) {
            optionsMap.put("wtimeoutms", (List<String>)optionsMap.remove("wtimeout"));
        }
        if (optionsMap.containsKey("slaveok") && !optionsMap.containsKey("readpreference")) {
            optionsMap.put("readpreference", Arrays.asList("secondaryPreferred"));
        }
        return optionsMap;
    }

    private ReadPreference buildReadPreference(String readPreferenceType, List<TagSet> tagSetList) {
        if (readPreferenceType != null) {
            if (tagSetList.isEmpty()) {
                return ReadPreference.valueOf(readPreferenceType);
            }
            return ReadPreference.valueOf(readPreferenceType, tagSetList);
        }
        return null;
    }

    private WriteConcern buildWriteConcern(Boolean safe, String w, int wTimeout, boolean fsync, boolean journal) {
        if (w != null || wTimeout != 0 || fsync || journal) {
            if (w == null) {
                return new WriteConcern(1, wTimeout, fsync, journal);
            }
            try {
                return new WriteConcern(Integer.parseInt(w), wTimeout, fsync, journal);
            }
            catch (NumberFormatException e) {
                return new WriteConcern(w, wTimeout, fsync, journal);
            }
        }
        if (safe != null) {
            if (safe.booleanValue()) {
                return WriteConcern.ACKNOWLEDGED;
            }
            return WriteConcern.UNACKNOWLEDGED;
        }
        return null;
    }

    private TagSet getTags(String tagSetString) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        if (tagSetString.length() > 0) {
            for (String tag : tagSetString.split(",")) {
                String[] tagKeyValuePair = tag.split(":");
                if (tagKeyValuePair.length != 2) {
                    throw new IllegalArgumentException("Bad read preference tags: " + tagSetString);
                }
                tagList.add(new Tag(tagKeyValuePair[0].trim(), tagKeyValuePair[1].trim()));
            }
        }
        return new TagSet(tagList);
    }

    boolean parseBoolean(String input) {
        String trimmedInput = input.trim();
        return trimmedInput.length() > 0 && (trimmedInput.equals("1") || trimmedInput.toLowerCase().equals("true") || trimmedInput.toLowerCase().equals("yes"));
    }

    public String getUsername() {
        return this.credentials != null ? this.credentials.getUserName() : null;
    }

    public char[] getPassword() {
        return this.credentials != null ? this.credentials.getPassword() : null;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getURI() {
        return this.uri;
    }

    public List<MongoCredential> getCredentialList() {
        return this.credentials != null ? Arrays.asList(this.credentials) : new ArrayList<MongoCredential>();
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Integer getMinConnectionPoolSize() {
        return this.minConnectionPoolSize;
    }

    public Integer getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public Integer getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public Integer getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public Integer getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public String toString() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionString)) {
            return false;
        }
        ConnectionString that = (ConnectionString)o;
        if (this.collection != null ? !this.collection.equals(that.collection) : that.collection != null) {
            return false;
        }
        if (this.connectTimeout != null ? !this.connectTimeout.equals(that.connectTimeout) : that.connectTimeout != null) {
            return false;
        }
        if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) {
            return false;
        }
        if (this.database != null ? !this.database.equals(that.database) : that.database != null) {
            return false;
        }
        if (!this.hosts.equals(that.hosts)) {
            return false;
        }
        if (this.maxConnectionIdleTime != null ? !this.maxConnectionIdleTime.equals(that.maxConnectionIdleTime) : that.maxConnectionIdleTime != null) {
            return false;
        }
        if (this.maxConnectionLifeTime != null ? !this.maxConnectionLifeTime.equals(that.maxConnectionLifeTime) : that.maxConnectionLifeTime != null) {
            return false;
        }
        if (this.maxConnectionPoolSize != null ? !this.maxConnectionPoolSize.equals(that.maxConnectionPoolSize) : that.maxConnectionPoolSize != null) {
            return false;
        }
        if (this.maxWaitTime != null ? !this.maxWaitTime.equals(that.maxWaitTime) : that.maxWaitTime != null) {
            return false;
        }
        if (this.minConnectionPoolSize != null ? !this.minConnectionPoolSize.equals(that.minConnectionPoolSize) : that.minConnectionPoolSize != null) {
            return false;
        }
        if (this.readPreference != null ? !this.readPreference.equals(that.readPreference) : that.readPreference != null) {
            return false;
        }
        if (this.requiredReplicaSetName != null ? !this.requiredReplicaSetName.equals(that.requiredReplicaSetName) : that.requiredReplicaSetName != null) {
            return false;
        }
        if (this.socketTimeout != null ? !this.socketTimeout.equals(that.socketTimeout) : that.socketTimeout != null) {
            return false;
        }
        if (this.sslEnabled != null ? !this.sslEnabled.equals(that.sslEnabled) : that.sslEnabled != null) {
            return false;
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != null ? !this.threadsAllowedToBlockForConnectionMultiplier.equals(that.threadsAllowedToBlockForConnectionMultiplier) : that.threadsAllowedToBlockForConnectionMultiplier != null) {
            return false;
        }
        return !(this.writeConcern != null ? !this.writeConcern.equals(that.writeConcern) : that.writeConcern != null);
    }

    public int hashCode() {
        int result = this.credentials != null ? this.credentials.hashCode() : 0;
        result = 31 * result + this.hosts.hashCode();
        result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
        result = 31 * result + (this.collection != null ? this.collection.hashCode() : 0);
        result = 31 * result + (this.readPreference != null ? this.readPreference.hashCode() : 0);
        result = 31 * result + (this.writeConcern != null ? this.writeConcern.hashCode() : 0);
        result = 31 * result + (this.minConnectionPoolSize != null ? this.minConnectionPoolSize.hashCode() : 0);
        result = 31 * result + (this.maxConnectionPoolSize != null ? this.maxConnectionPoolSize.hashCode() : 0);
        result = 31 * result + (this.threadsAllowedToBlockForConnectionMultiplier != null ? this.threadsAllowedToBlockForConnectionMultiplier.hashCode() : 0);
        result = 31 * result + (this.maxWaitTime != null ? this.maxWaitTime.hashCode() : 0);
        result = 31 * result + (this.maxConnectionIdleTime != null ? this.maxConnectionIdleTime.hashCode() : 0);
        result = 31 * result + (this.maxConnectionLifeTime != null ? this.maxConnectionLifeTime.hashCode() : 0);
        result = 31 * result + (this.connectTimeout != null ? this.connectTimeout.hashCode() : 0);
        result = 31 * result + (this.socketTimeout != null ? this.socketTimeout.hashCode() : 0);
        result = 31 * result + (this.sslEnabled != null ? this.sslEnabled.hashCode() : 0);
        result = 31 * result + (this.requiredReplicaSetName != null ? this.requiredReplicaSetName.hashCode() : 0);
        return result;
    }

    static {
        GENERAL_OPTIONS_KEYS.add("minpoolsize");
        GENERAL_OPTIONS_KEYS.add("maxpoolsize");
        GENERAL_OPTIONS_KEYS.add("waitqueuemultiple");
        GENERAL_OPTIONS_KEYS.add("waitqueuetimeoutms");
        GENERAL_OPTIONS_KEYS.add("connecttimeoutms");
        GENERAL_OPTIONS_KEYS.add("maxidletimems");
        GENERAL_OPTIONS_KEYS.add("maxlifetimems");
        GENERAL_OPTIONS_KEYS.add("sockettimeoutms");
        GENERAL_OPTIONS_KEYS.add("sockettimeoutms");
        GENERAL_OPTIONS_KEYS.add("ssl");
        GENERAL_OPTIONS_KEYS.add("replicaset");
        READ_PREFERENCE_KEYS.add("readpreference");
        READ_PREFERENCE_KEYS.add("readpreferencetags");
        WRITE_CONCERN_KEYS.add("safe");
        WRITE_CONCERN_KEYS.add("w");
        WRITE_CONCERN_KEYS.add("wtimeoutms");
        WRITE_CONCERN_KEYS.add("fsync");
        WRITE_CONCERN_KEYS.add("j");
        AUTH_KEYS.add("authmechanism");
        AUTH_KEYS.add("authsource");
        AUTH_KEYS.add("gssapiservicename");
        AUTH_KEYS.add("authmechanismproperties");
        ALL_KEYS.addAll(GENERAL_OPTIONS_KEYS);
        ALL_KEYS.addAll(AUTH_KEYS);
        ALL_KEYS.addAll(READ_PREFERENCE_KEYS);
        ALL_KEYS.addAll(WRITE_CONCERN_KEYS);
    }
}

