/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.ansible;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Beta
public interface AnsibleConfig {
    @SetFromFlag(value="playbook")
    public static final ConfigKey<String> ANSIBLE_PLAYBOOK = ConfigKeys.newStringConfigKey((String)"brooklyn.ansible.playbook", (String)"Name to be used for a playbook to be execute by Ansible");
    @SetFromFlag(value="playbook.yaml")
    public static final ConfigKey<String> ANSIBLE_PLAYBOOK_YAML = ConfigKeys.newStringConfigKey((String)"brooklyn.ansible.playbookYaml", (String)"Playbook contents as YAML in a string, to be execute by Ansible");
    @SetFromFlag(value="playbook.url")
    public static final ConfigKey<String> ANSIBLE_PLAYBOOK_URL = ConfigKeys.newStringConfigKey((String)"brooklyn.ansible.playbookUrl");
    @SetFromFlag(value="ansible.service.start")
    public static final ConfigKey<String> ANSIBLE_SERVICE_START = ConfigKeys.newStringConfigKey((String)"ansible.service.start", (String)"Default start command used with conjunction with the Ansible's service module", (String)"ansible localhost -c local -m service -a \"name=%s state=started\"");
    @SetFromFlag(value="ansible.service.stop")
    public static final ConfigKey<String> ANSIBLE_SERVICE_STOP = ConfigKeys.newStringConfigKey((String)"ansible.service.stop", (String)"Default stop command used with conjunction with the Ansible's service module", (String)"ansible localhost -c local -m service -a \"name=%s state=stopped\"");
    @SetFromFlag(value="ansible.service.checkHost")
    public static final ConfigKey<String> ANSIBLE_SERVICE_CHECK_HOST = ConfigKeys.newStringConfigKey((String)"ansible.service.check.host", (String)"IP to be checked. Default: All IPs ", (String)"0.0.0.0");
    @SetFromFlag(value="ansible.service.checkPort")
    public static final ConfigKey<Integer> ANSIBLE_SERVICE_CHECK_PORT = ConfigKeys.newIntegerConfigKey((String)"ansible.service.check.port");
    @SetFromFlag(value="service.name")
    public static final ConfigKey<String> SERVICE_NAME = ConfigKeys.newStringConfigKey((String)"brooklyn.ansible.serviceName", (String)"Name of OS service this will run as, for use in checking running and stopping");
    @SetFromFlag(value="ansible.vars")
    public static final ConfigKey<Object> ANSIBLE_VARS = ConfigKeys.newConfigKey(Object.class, (String)"brooklyn.ansible.vars", (String)"Ansible 'extra-vars' variable configuration values");

    public static enum AnsibleModes {
        PLAYBOOK;

    }
}

