/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.rest.api.SensorApi;
import org.apache.brooklyn.rest.domain.SensorSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.SensorTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class SensorResource
extends AbstractBrooklynRestResource
implements SensorApi {
    private static final Logger log = LoggerFactory.getLogger(SensorResource.class);

    public List<SensorSummary> list(String application, String entityToken) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        ArrayList result = Lists.newArrayList();
        for (AttributeSensor sensor : Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class)) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_SENSOR, (Object)new Entitlements.EntityAndItem(entity, (Object)sensor.getName()))) {
                log.trace("User {} not authorized to see sensor {} of entity {}; excluding from AttributeSensor list results", new Object[]{Entitlements.getEntitlementContext().user(), sensor.getName(), entity});
                continue;
            }
            result.add(SensorTransformer.sensorSummary(entity, sensor, this.ui.getBaseUriBuilder()));
        }
        return result;
    }

    public Map<String, Object> batchSensorRead(String application, String entityToken, Boolean raw) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        HashMap sensorMap = Maps.newHashMap();
        Iterable sensors = Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class);
        for (AttributeSensor sensor : sensors) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_SENSOR, (Object)new Entitlements.EntityAndItem(entity, (Object)sensor.getName()))) {
                log.trace("User {} not authorized to see sensor {} of entity {}; excluding from current-state results", new Object[]{Entitlements.getEntitlementContext().user(), sensor.getName(), entity});
                continue;
            }
            Object value = entity.getAttribute(this.findSensor(entity, sensor.getName()));
            sensorMap.put(sensor.getName(), this.resolving(value).preferJson(true).asJerseyOutermostReturnValue(false).raw(raw).context(entity).timeout(Duration.ZERO).renderAs(sensor).resolve());
        }
        return sensorMap;
    }

    protected Object get(boolean preferJson, String application, String entityToken, String sensorName, Boolean raw) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_SENSOR, (Object)new Entitlements.EntityAndItem(entity, (Object)sensor.getName()))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s' sensor '%s'", Entitlements.getEntitlementContext().user(), entity, sensor.getName());
        }
        Object value = entity.getAttribute(sensor);
        return this.resolving(value).preferJson(preferJson).asJerseyOutermostReturnValue(true).raw(raw).context(entity).immediately(true).renderAs(sensor).resolve();
    }

    public String getPlain(String application, String entityToken, String sensorName, Boolean raw) {
        return (String)this.get(false, application, entityToken, sensorName, raw);
    }

    public Object get(String application, String entityToken, String sensorName, Boolean raw) {
        return this.get(true, application, entityToken, sensorName, raw);
    }

    private AttributeSensor<?> findSensor(Entity entity, String name) {
        Sensor s = entity.getEntityType().getSensor(name);
        if (s instanceof AttributeSensor) {
            return (AttributeSensor)s;
        }
        return new BasicAttributeSensor(Object.class, name);
    }

    public void setFromMap(String application, String entityToken, Map newValues) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        if (log.isDebugEnabled()) {
            log.debug("REST user " + Entitlements.getEntitlementContext() + " setting sensors " + newValues);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            String sensorName = Strings.toString(entry.getKey());
            Object newValue = entry.getValue();
            AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
            entity.sensors().set(sensor, newValue);
        }
    }

    public void set(String application, String entityToken, String sensorName, Object newValue) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
        if (log.isDebugEnabled()) {
            log.debug("REST user " + Entitlements.getEntitlementContext() + " setting sensor " + sensorName + " to " + newValue);
        }
        entity.sensors().set(sensor, newValue);
    }

    public void delete(String application, String entityToken, String sensorName) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
        if (log.isDebugEnabled()) {
            log.debug("REST user " + Entitlements.getEntitlementContext() + " deleting sensor " + sensorName);
        }
        ((EntityInternal)entity).sensors().remove(sensor);
    }
}

