/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.salt;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.config.SetConfigKey;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.entity.cm.salt.SaltConfig;

@Beta
public class SaltConfigs {
    public static void addToRunList(EntitySpec<?> entity, String ... states) {
        for (String state : states) {
            entity.configure(SaltConfig.START_STATES, (Object)SetConfigKey.SetModifications.addItem((Object)state));
        }
    }

    public static void addToRunList(EntityInternal entity, String ... states) {
        for (String state : states) {
            entity.config().set(SaltConfig.START_STATES, (Object)SetConfigKey.SetModifications.addItem((Object)state));
        }
    }

    public static void addLaunchAttributes(EntitySpec<?> entity, Map<?, ?> attributesMap) {
        entity.configure(SaltConfig.SALT_SSH_LAUNCH_ATTRIBUTES, (Object)MapConfigKey.MapModifications.add(attributesMap));
    }

    public static void addLaunchAttributes(EntityInternal entity, Map<?, ?> attributesMap) {
        entity.config().set(SaltConfig.SALT_SSH_LAUNCH_ATTRIBUTES, (Object)MapConfigKey.MapModifications.add(attributesMap));
    }

    public static void addToFormulas(EntitySpec<?> entity, String formulaUrl) {
        entity.configure(SaltConfig.SALT_FORMULAS, (Object)SetConfigKey.SetModifications.addItem((Object)formulaUrl));
    }

    public static void addToFormulas(EntityInternal entity, String formulaUrl) {
        entity.config().set(SaltConfig.SALT_FORMULAS, (Object)SetConfigKey.SetModifications.addItem((Object)formulaUrl));
    }

    public static <T> T getRequiredConfig(Entity entity, ConfigKey<T> key) {
        return (T)Preconditions.checkNotNull((Object)((Entity)Preconditions.checkNotNull((Object)entity, (Object)"Entity must be supplied")).getConfig(key), (Object)("Key " + key + " is required on " + entity));
    }
}

