/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraDatacenter;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraFabric;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNode;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNodeDriver;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNodeImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskWrapper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CassandraNodeSshDriver
extends JavaSoftwareProcessSshDriver
implements CassandraNodeDriver {
    private static final Logger log = LoggerFactory.getLogger(CassandraNodeSshDriver.class);
    protected Maybe<String> resolvedAddressCache = Maybe.absent();

    public CassandraNodeSshDriver(CassandraNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "cassandra.log"});
    }

    @Override
    public Integer getGossipPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CassandraNode.GOSSIP_PORT);
    }

    @Override
    public Integer getSslGossipPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CassandraNode.SSL_GOSSIP_PORT);
    }

    @Override
    public Integer getThriftPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CassandraNode.THRIFT_PORT);
    }

    @Override
    public Integer getNativeTransportPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CassandraNode.NATIVE_TRANSPORT_PORT);
    }

    @Override
    public String getClusterName() {
        return (String)this.entity.getAttribute(CassandraNode.CLUSTER_NAME);
    }

    @Override
    public String getCassandraConfigTemplateUrl() {
        String templatedUrl = (String)this.entity.getConfig(CassandraNode.CASSANDRA_CONFIG_TEMPLATE_URL);
        return TemplateProcessor.processTemplateContents((String)templatedUrl, (EntityDriver)this, (Map)ImmutableMap.of());
    }

    @Override
    public String getCassandraConfigFileName() {
        return (String)this.entity.getConfig(CassandraNode.CASSANDRA_CONFIG_FILE_NAME);
    }

    public String getEndpointSnitchName() {
        return (String)this.entity.getConfig(CassandraNode.ENDPOINT_SNITCH_NAME);
    }

    public String getCassandraRackdcConfigTemplateUrl() {
        return (String)this.entity.getConfig(CassandraNode.CASSANDRA_RACKDC_CONFIG_TEMPLATE_URL);
    }

    public String getCassandraRackdcConfigFileName() {
        return (String)this.entity.getConfig(CassandraNode.CASSANDRA_RACKDC_CONFIG_FILE_NAME);
    }

    public String getMirrorUrl() {
        return (String)this.entity.getConfig(CassandraNode.MIRROR_URL);
    }

    protected boolean isV2() {
        String version = this.getVersion();
        return version.startsWith("2.");
    }

    public boolean installJava() {
        if (this.isV2()) {
            return this.checkForAndInstallJava("1.8");
        }
        return super.installJava();
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_TAR).add((Object)("tar xzfv " + saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public Set<Integer> getPortsUsed() {
        return ImmutableSet.builder().addAll((Iterable)super.getPortsUsed()).addAll(this.getPortMap().values()).build();
    }

    protected Map<String, Integer> getPortMap() {
        return ImmutableMap.builder().put((Object)"jmxPort", this.entity.getAttribute((AttributeSensor)UsesJmx.JMX_PORT)).put((Object)"rmiPort", this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT)).put((Object)"gossipPort", (Object)this.getGossipPort()).put((Object)"sslGossipPort", (Object)this.getSslGossipPort()).put((Object)"thriftPort", (Object)this.getThriftPort()).build();
    }

    public void customize() {
        log.debug("Customizing {} (Cluster {})", (Object)this.entity, (Object)this.getClusterName());
        Networking.checkPortsValid(this.getPortMap());
        this.customizeInitialSeeds();
        String logFileEscaped = this.getLogFileLocation().replace("/", "\\/");
        ImmutableList.Builder commands = new ImmutableList.Builder().add((Object)String.format("cp -R %s/{bin,conf,lib,interface,pylib,tools} .", this.getExpandedInstallDir())).add((Object)"mkdir -p data").add((Object)"mkdir -p brooklyn_commands").add((Object)String.format("sed -i.bk 's/log4j.appender.R.File=.*/log4j.appender.R.File=%s/g' %s/conf/log4j-server.properties", logFileEscaped, this.getRunDir())).add((Object)String.format("sed -i.bk '/JMX_PORT/d' %s/conf/cassandra-env.sh", this.getRunDir())).add((Object)String.format("sed -i.bk 's/-Xss180k/-Xss280k/g' %s/conf/cassandra-env.sh", this.getRunDir()));
        this.newScript((String)"customizing").body.append((Collection)commands.build()).failOnNonZeroResultCode().execute();
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf", this.getCassandraConfigFileName()});
        this.copyTemplate(this.getCassandraConfigTemplateUrl(), destinationConfigFile);
        String rackdcDestinationFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf", this.getCassandraRackdcConfigFileName()});
        this.copyTemplate(this.getCassandraRackdcConfigTemplateUrl(), rackdcDestinationFile);
        this.customizeCopySnitch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customizeCopySnitch() {
        String customSnitchJarUrl = (String)this.entity.getConfig(CassandraNode.CUSTOM_SNITCH_JAR_URL);
        if (Strings.isNonBlank((CharSequence)customSnitchJarUrl)) {
            int lastSlashIndex = customSnitchJarUrl.lastIndexOf("/");
            String customSnitchJarName = lastSlashIndex > 0 ? customSnitchJarUrl.substring(lastSlashIndex + 1) : "customBrooklynSnitch.jar";
            String jarDestinationFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "lib", customSnitchJarName});
            InputStream customSnitchJarStream = (InputStream)Preconditions.checkNotNull((Object)this.resource.getResourceFromUrl(customSnitchJarUrl), (String)"%s could not be loaded", (Object[])new Object[]{customSnitchJarUrl});
            try {
                this.getMachine().copyTo(customSnitchJarStream, jarDestinationFile);
            }
            finally {
                Streams.closeQuietly((Closeable)customSnitchJarStream);
            }
        }
    }

    protected void customizeInitialSeeds() {
        if (this.entity.getConfig(CassandraNode.INITIAL_SEEDS) == null) {
            if (this.isClustered()) {
                this.entity.config().set(CassandraNode.INITIAL_SEEDS, DependentConfiguration.attributeWhenReady((Entity)this.entity.getParent(), CassandraDatacenter.CURRENT_SEEDS));
            } else {
                this.entity.config().set(CassandraNode.INITIAL_SEEDS, (Object)MutableSet.of((Object)this.entity));
            }
        }
    }

    @Override
    public boolean isClustered() {
        return this.entity.getParent() instanceof CassandraDatacenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void launch() {
        long firstStartTime;
        Object toWait;
        String subnetHostname = (String)Machines.findSubnetOrPublicHostname((Entity)this.entity).get();
        Set seeds = (Set)this.getEntity().getConfig(CassandraNode.INITIAL_SEEDS);
        List<Entity> ancestors = this.getCassandraAncestors();
        log.info("Launching " + this.entity + ": cluster " + this.getClusterName() + ", hostname (public) " + (String)this.getEntity().getAttribute(Attributes.HOSTNAME) + ", hostname (subnet) " + subnetHostname + ", seeds " + ((CassandraNode)this.entity).getSeeds() + " (from " + seeds + ")");
        boolean isFirst = ((Entity)seeds.iterator().next()).equals(this.entity);
        if (this.isClustered() && !isFirst && (toWait = Duration.millis((Number)((firstStartTime = ((Long)((Task)Entities.submit((Entity)this.entity, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)ancestors.get(ancestors.size() - 1), CassandraDatacenter.FIRST_NODE_STARTED_TIME_UTC))).getUnchecked()).longValue()) + CassandraDatacenter.DELAY_AFTER_FIRST.toMilliseconds() - System.currentTimeMillis()))).toMilliseconds() > 0L) {
            log.info("Launching " + this.entity + ": delaying launch of non-first node by " + toWait + " to prevent schema disagreements");
            Tasks.setBlockingDetails((String)"Pausing to ensure first node has time to start");
            Time.sleep((Duration)toWait);
            Tasks.resetBlockingDetails();
        }
        List queuedStart = null;
        if (CassandraDatacenter.DELAY_BETWEEN_STARTS != null && !ancestors.isEmpty()) {
            Entity root = ancestors.get(ancestors.size() - 1);
            toWait = CassandraNode.class;
            // MONITORENTER : org.apache.brooklyn.entity.nosql.cassandra.CassandraNode.class
            queuedStart = (List)root.getAttribute(CassandraDatacenter.QUEUED_START_NODES);
            if (queuedStart == null) {
                queuedStart = new ArrayList<EntityLocal>();
                root.sensors().set(CassandraDatacenter.QUEUED_START_NODES, queuedStart);
            }
            queuedStart.add(this.getEntity());
            root.sensors().set(CassandraDatacenter.QUEUED_START_NODES, queuedStart);
            // MONITOREXIT : toWait
            while (true) {
                if (((Entity)(queuedStart = (List)root.getAttribute(CassandraDatacenter.QUEUED_START_NODES)).get(0)).equals(this.getEntity())) {
                    CassandraDatacenter.DELAY_BETWEEN_STARTS.countdownTimer().waitForExpiryUnchecked();
                    break;
                }
                toWait = queuedStart;
                // MONITORENTER : toWait
                try {
                    queuedStart.wait(1000L);
                }
                catch (InterruptedException e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
        }
        try {
            Object creationScript;
            this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{"echo date on cassandra server `hostname` when launching is `date`", this.launchEssentialCommand(), "echo after essential command"}).execute();
            if (!this.isClustered() && (creationScript = DatastoreMixins.getDatabaseCreationScript((Entity)this.entity)) != null) {
                Tasks.setBlockingDetails((String)"Pausing to ensure Cassandra (singleton) has started before running creation script");
                Time.sleep((Duration)Duration.seconds((Number)20));
                Tasks.resetBlockingDetails();
                this.executeScriptAsync(Streams.readFullyStringAndClose((InputStream)creationScript));
            }
            if (!this.isClustered()) return;
            if (!isFirst) return;
            creationScript = this.getCassandraAncestors().iterator();
            while (creationScript.hasNext()) {
                Entity ancestor = (Entity)creationScript.next();
                ancestor.sensors().set(CassandraDatacenter.FIRST_NODE_STARTED_TIME_UTC, (Object)System.currentTimeMillis());
            }
            return;
        }
        finally {
            if (queuedStart != null) {
                Entity head = (Entity)queuedStart.remove(0);
                Preconditions.checkArgument((boolean)head.equals(this.getEntity()), (Object)("first queued node was " + head + " but we are " + this.getEntity()));
                List list = queuedStart;
            }
        }
    }

    protected List<Entity> getCassandraAncestors() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity ancestor = this.getEntity().getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!(ancestor instanceof CassandraDatacenter) && !(ancestor instanceof CassandraFabric)) continue;
            result.add(ancestor);
        }
        return result;
    }

    protected String launchEssentialCommand() {
        if (this.isV2()) {
            return String.format("./bin/cassandra -p %s > ./cassandra-console.log 2>&1", this.getPidFile());
        }
        return String.format("nohup ./bin/cassandra -p %s > ./cassandra-console.log 2>&1 &", this.getPidFile());
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "cassandra.pid"});
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    protected Map<String, String> getCustomJavaSystemProperties() {
        return MutableMap.builder().putAll(super.getCustomJavaSystemProperties()).put((Object)"cassandra.config", (Object)this.getCassandraConfigFileName()).build();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"CASSANDRA_HOME", (Object)this.getRunDir()).put((Object)"CASSANDRA_CONF", (Object)Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf"})).renameKey((Object)"JAVA_OPTS", (Object)"JVM_OPTS").build();
    }

    @Override
    public ProcessTaskWrapper<Integer> executeScriptAsync(String commands) {
        String fileToRun = Os.mergePathsUnix((String[])new String[]{"brooklyn_commands", "cassandra-commands-" + Identifiers.makeRandomId((int)8)});
        SshPutTaskWrapper task = SshEffectorTasks.put((String)Os.mergePathsUnix((String[])new String[]{this.getRunDir(), fileToRun})).machine(this.getMachine()).contents(commands).summary("copying cassandra script to execute " + fileToRun).newTask();
        DynamicTasks.queueIfPossible((TaskAdaptable)task).orSubmitAndBlock((Entity)this.getEntity()).andWaitForSuccess();
        return this.executeScriptFromInstalledFileAsync(fileToRun);
    }

    public ProcessTaskWrapper<Integer> executeScriptFromInstalledFileAsync(String fileToRun) {
        ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), this.scriptInvocationCommand(this.getThriftPort(), fileToRun)}).machine(this.getMachine())).summary("executing cassandra script " + fileToRun)).newTask();
        DynamicTasks.queueIfPossible((TaskAdaptable)task).orSubmitAndBlock((Entity)this.getEntity());
        return task;
    }

    protected String scriptInvocationCommand(Integer optionalThriftPort, String fileToRun) {
        return "bin/cassandra-cli " + (optionalThriftPort != null ? "--port " + optionalThriftPort : "") + " --file " + fileToRun;
    }

    @Override
    public String getResolvedAddress(String hostname) {
        return (String)this.resolvedAddressCache.or(BrooklynAccessUtils.resolvedAddressSupplier((Entity)this.getEntity(), (SshMachineLocation)this.getMachine(), (String)hostname));
    }
}

