/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import java.net.URI;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Endpoint;

public abstract class Endpoint {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String region();

    @Nullable
    public abstract String regionId();

    @Nullable
    public abstract String serviceId();

    public abstract URI url();

    @Nullable
    public abstract Boolean enabled();

    public abstract String iface();

    @SerializedNames(value={"id", "region", "region_id", "service_id", "url", "enabled", "interface"})
    public static Endpoint create(String id, String region, String regionId, String serviceId, URI url, Boolean enabled, String iface) {
        return Endpoint.builder().id(serviceId).region(region).regionId(regionId).serviceId(serviceId).url(url).enabled(enabled).iface(iface).build();
    }

    Endpoint() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Endpoint.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder region(String var1);

        public abstract Builder regionId(String var1);

        public abstract Builder serviceId(String var1);

        public abstract Builder url(URI var1);

        public abstract Builder enabled(Boolean var1);

        public abstract Builder iface(String var1);

        public abstract Endpoint build();
    }
}

