/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.time.Duration;

public interface ShellTool {
    public static final ConfigKey<String> PROP_LOCAL_TEMP_DIR = ConfigKeys.newStringConfigKey("localTempDir", "The directory on the local machine (i.e. running brooklyn) for writing temp files", Os.mergePaths((String[])new String[]{Os.tmp(), "brooklyn-" + Os.user() + "-ssh-tmp"}));
    public static final ConfigKey<Boolean> PROP_RUN_AS_ROOT = ConfigKeys.newConfigKey("runAsRoot", "When running a script, whether to run as root", Boolean.FALSE);
    public static final ConfigKey<Boolean> PROP_AUTH_SUDO = ConfigKeys.newConfigKey("authSudo", "When to run `sudo` commands with password authentication", Boolean.FALSE);
    public static final ConfigKey<String> PROP_PASSWORD = ConfigKeys.newStringConfigKey("password", "Password to use (e.g. for authSudo, or for ssh to connect)", null);
    public static final ConfigKey<OutputStream> PROP_OUT_STREAM = ConfigKeys.newConfigKey(OutputStream.class, "out", "Stream to which to capture stdout");
    public static final ConfigKey<OutputStream> PROP_ERR_STREAM = ConfigKeys.newConfigKey(OutputStream.class, "err", "Stream to which to capture stderr");
    public static final ConfigKey<Boolean> PROP_NO_EXTRA_OUTPUT = ConfigKeys.newConfigKey("noExtraOutput", "Suppresses any decorative output such as result code which some tool commands insert", false);
    public static final ConfigKey<String> PROP_SEPARATOR = ConfigKeys.newConfigKey("separator", "string to insert between caller-supplied commands being executed as commands", " ; ");
    public static final ConfigKey<String> PROP_SCRIPT_DIR = ConfigKeys.newConfigKey("scriptDir", "directory where scripts should be copied", "/tmp");
    public static final ConfigKey<String> PROP_SCRIPT_HEADER = ConfigKeys.newConfigKey("scriptHeader", "lines to insert at the start of scripts generated for caller-supplied commands for script execution", "#!/bin/bash -e\n");
    public static final ConfigKey<String> PROP_DIRECT_HEADER = ConfigKeys.newConfigKey("directHeader", "commands to run at the target before any caller-supplied commands for direct execution", "exec bash -e");
    public static final ConfigKey<Boolean> PROP_NO_DELETE_SCRIPT = ConfigKeys.newConfigKey("noDeleteAfterExec", "Retains the generated script file after executing the commands instead of deleting it", false);
    public static final ConfigKey<String> PROP_SUMMARY = ConfigKeys.newStringConfigKey("summary", "Provides a human-readable summary, used in file generation etc");
    public static final ConfigKey<Duration> PROP_EXEC_TIMEOUT = ConfigKeys.newConfigKey("execTimeout", "Timeout when executing a script", Duration.PRACTICALLY_FOREVER);
    public static final ConfigKey<Boolean> PROP_EXEC_ASYNC = ConfigKeys.newConfigKey("execAsync", "Executes the script asynchronously, and then polls for the result (and for stdout/stderr)", false);
    public static final ConfigKey<Duration> PROP_EXEC_ASYNC_POLLING_TIMEOUT = ConfigKeys.newConfigKey("execAsyncPollTimeout", "Timeout per poll when executing a script asynchronously", Duration.ONE_MINUTE);

    public int execScript(Map<String, ?> var1, List<String> var2, Map<String, ?> var3);

    public int execScript(Map<String, ?> var1, List<String> var2);

    public int execCommands(Map<String, ?> var1, List<String> var2, Map<String, ?> var3);

    public int execCommands(Map<String, ?> var1, List<String> var2);
}

