/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.AttributePollHandler;
import org.apache.brooklyn.core.feed.DelegatingPollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandFeed
extends AbstractFeed {
    public static final Logger log = LoggerFactory.getLogger(AbstractCommandFeed.class);
    public static final ConfigKey<Supplier<MachineLocation>> MACHINE = ConfigKeys.newConfigKey(new TypeToken<Supplier<MachineLocation>>(){}, "machine");
    public static final ConfigKey<Boolean> EXEC_AS_COMMAND = ConfigKeys.newBooleanConfigKey("execAsCommand");
    public static final ConfigKey<SetMultimap<CommandPollIdentifier, CommandPollConfig<?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<SetMultimap<CommandPollIdentifier, CommandPollConfig<?>>>(){}, "polls");

    public AbstractCommandFeed() {
    }

    protected AbstractCommandFeed(Builder builder) {
        this.config().set(ONLY_IF_SERVICE_UP, builder.onlyIfServiceUp);
        this.config().set(MACHINE, builder.machine);
        this.config().set(EXEC_AS_COMMAND, builder.execAsCommand);
        HashMultimap polls = HashMultimap.create();
        for (CommandPollConfig<?> config : builder.getPolls()) {
            CommandPollConfig configCopy = new CommandPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            polls.put((Object)new CommandPollIdentifier(config.getCommandSupplier(), config.getEnvSupplier()), configCopy);
        }
        this.config().set(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls.values());
    }

    protected MachineLocation getMachine() {
        Supplier supplier = (Supplier)this.config().get(MACHINE);
        if (supplier != null) {
            return (MachineLocation)supplier.get();
        }
        return (MachineLocation)Locations.findUniqueMachineLocation(this.entity.getLocations()).get();
    }

    @Override
    protected void preStart() {
        SetMultimap polls = (SetMultimap)this.config().get(POLLS);
        for (final CommandPollIdentifier pollInfo : polls.keySet()) {
            Set configs = polls.get((Object)pollInfo);
            long minPeriod = Integer.MAX_VALUE;
            LinkedHashSet handlers = Sets.newLinkedHashSet();
            for (CommandPollConfig config : configs) {
                handlers.add(new AttributePollHandler(config, (Entity)this.entity, this));
                if (config.getPeriod() <= 0L) continue;
                minPeriod = Math.min(minPeriod, config.getPeriod());
            }
            this.getPoller().scheduleAtFixedRate(new Callable<SshPollValue>(){

                @Override
                public SshPollValue call() throws Exception {
                    return AbstractCommandFeed.this.exec((String)pollInfo.command.get(), (Map)pollInfo.env.get());
                }
            }, new DelegatingPollHandler(handlers), minPeriod);
        }
    }

    protected Poller<SshPollValue> getPoller() {
        return super.getPoller();
    }

    protected abstract SshPollValue exec(String var1, Map<String, String> var2) throws IOException;

    private static class CommandPollIdentifier {
        final Supplier<String> command;
        final Supplier<Map<String, String>> env;

        private CommandPollIdentifier(Supplier<String> command, Supplier<Map<String, String>> env) {
            this.command = (Supplier)Preconditions.checkNotNull(command, (Object)"command");
            this.env = (Supplier)Preconditions.checkNotNull(env, (Object)"env");
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.command, this.env});
        }

        public boolean equals(Object other) {
            if (!(other instanceof CommandPollIdentifier)) {
                return false;
            }
            CommandPollIdentifier o = (CommandPollIdentifier)other;
            return Objects.equal(this.command, o.command) && Objects.equal(this.env, o.env);
        }
    }

    public static abstract class Builder<T extends AbstractCommandFeed, B extends Builder<T, B>> {
        private Entity entity;
        private boolean onlyIfServiceUp = false;
        private Supplier<MachineLocation> machine;
        private Duration period = Duration.of((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        private boolean execAsCommand = false;
        private String uniqueTag;
        private volatile boolean built;

        public B entity(Entity val) {
            this.entity = val;
            return this.self();
        }

        public B onlyIfServiceUp() {
            return this.onlyIfServiceUp(true);
        }

        public B onlyIfServiceUp(boolean onlyIfServiceUp) {
            this.onlyIfServiceUp = onlyIfServiceUp;
            return this.self();
        }

        public B machine(MachineLocation val) {
            return this.machine((Supplier<MachineLocation>)Suppliers.ofInstance((Object)val));
        }

        public B machine(Supplier<MachineLocation> val) {
            this.machine = val;
            return this.self();
        }

        public B period(Duration period) {
            this.period = period;
            return this.self();
        }

        public B period(long millis) {
            return this.period(Duration.of((long)millis, (TimeUnit)TimeUnit.MILLISECONDS));
        }

        public B period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public abstract B poll(CommandPollConfig<?> var1);

        public abstract List<CommandPollConfig<?>> getPolls();

        public B execAsCommand() {
            this.execAsCommand = true;
            return this.self();
        }

        public B execAsScript() {
            this.execAsCommand = false;
            return this.self();
        }

        public B uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this.self();
        }

        protected abstract B self();

        protected abstract T instantiateFeed();

        public T build() {
            this.built = true;
            T result = this.instantiateFeed();
            ((AbstractFeed)result).setEntity((EntityLocal)Preconditions.checkNotNull((Object)((EntityLocal)this.entity), (Object)"entity"));
            ((AbstractFeed)result).start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("SshFeed.Builder created, but build() never called");
            }
        }
    }
}

