/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;

@Beta
public class AddEffector
implements EntityInitializer {
    public static final ConfigKey<String> EFFECTOR_NAME = ConfigKeys.newStringConfigKey("name");
    public static final ConfigKey<String> EFFECTOR_DESCRIPTION = ConfigKeys.newStringConfigKey("description");
    public static final ConfigKey<Map<String, Object>> EFFECTOR_PARAMETER_DEFS = new MapConfigKey<Object>(Object.class, "parameters");
    protected final Effector<?> effector;

    public AddEffector(Effector<?> effector) {
        this.effector = (Effector)Preconditions.checkNotNull(effector, (Object)"effector");
    }

    public void apply(EntityLocal entity) {
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.effector);
    }

    public static <T> Effectors.EffectorBuilder<T> newEffectorBuilder(Class<T> type, ConfigBag params) {
        String name = (String)Preconditions.checkNotNull((Object)params.get(EFFECTOR_NAME), (String)"name must be supplied when defining an effector: %s", (Object[])new Object[]{params});
        Effectors.EffectorBuilder<T> eff = Effectors.effector(type, name);
        eff.description(params.get(EFFECTOR_DESCRIPTION));
        Map<String, Object> paramDefs = params.get(EFFECTOR_PARAMETER_DEFS);
        if (paramDefs != null) {
            for (Map.Entry<String, Object> paramDef : paramDefs.entrySet()) {
                if (paramDef == null) continue;
                String paramName = paramDef.getKey();
                Map value = paramDef.getValue();
                if (value == null) {
                    value = Collections.emptyMap();
                }
                if (!(value instanceof Map) && value instanceof CharSequence && Strings.isBlank((CharSequence)((CharSequence)((Object)value)))) {
                    value = Collections.emptyMap();
                }
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("Illegal argument of type " + value.getClass() + " value '" + value + "' supplied as parameter definition '" + paramName);
                }
                eff.parameter(ConfigKeys.DynamicKeys.newNamedInstance(paramName, value));
            }
        }
        return eff;
    }

    public static ConfigBag getMergedParams(Effector<?> eff, ConfigBag params) {
        ConfigBag result = ConfigBag.newInstanceCopying(params);
        for (ParameterType param : eff.getParameters()) {
            ConfigKey key = Effectors.asConfigKey(param);
            if (result.containsKey(key)) continue;
            result.configure(key, params.get(key));
        }
        return result;
    }
}

