/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;

public class KeyProviderUtil {
    public static KeyFormat detectKeyFileFormat(File location) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new FileReader(location), new File(location + ".pub").exists());
    }

    public static KeyFormat detectKeyFileFormat(String privateKey, boolean separatePubKey) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new StringReader(privateKey), separatePubKey);
    }

    public static KeyFormat detectKeyFileFormat(Reader privateKey, boolean separatePubKey) throws IOException {
        String header = KeyProviderUtil.readHeader(privateKey);
        if (header == null) {
            throw new IOException("Empty file");
        }
        return KeyProviderUtil.keyFormatFromHeader(header, separatePubKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readHeader(Reader privateKey) throws IOException {
        String string;
        BufferedReader br = new BufferedReader(privateKey);
        try {
            String header;
            while ((header = br.readLine()) != null && (header = header.trim()).isEmpty()) {
            }
            string = header;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly(br);
        return string;
    }

    private static KeyFormat keyFormatFromHeader(String header, boolean separatePubKey) {
        if (header.startsWith("-----BEGIN") && header.endsWith("PRIVATE KEY-----")) {
            if (separatePubKey && header.contains("OPENSSH PRIVATE KEY-----")) {
                return KeyFormat.OpenSSHv1;
            }
            if (separatePubKey) {
                return KeyFormat.OpenSSH;
            }
            if (header.contains("BEGIN PRIVATE KEY") || header.contains("BEGIN ENCRYPTED PRIVATE KEY")) {
                return KeyFormat.PKCS8;
            }
            return KeyFormat.PKCS5;
        }
        if (header.startsWith("PuTTY-User-Key-File-")) {
            return KeyFormat.PuTTY;
        }
        return KeyFormat.Unknown;
    }
}

