/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import io.airlift.airline.Arguments;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.OptionType;
import io.airlift.airline.ParseException;
import io.airlift.airline.model.GlobalMetadata;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMain {
    private static final Logger log = LoggerFactory.getLogger(AbstractMain.class);
    public static final String DEFAULT_BANNER;
    public static final int SUCCESS = 0;
    public static final int PARSE_ERROR = 1;
    public static final int EXECUTION_ERROR = 2;
    public static final int CONFIGURATION_ERROR = 3;
    protected static volatile String banner;
    protected static volatile String productOneLineSummary;

    protected String cliScriptName() {
        return "brooklyn";
    }

    protected abstract Cli.CliBuilder<BrooklynCommand> cliBuilder();

    protected void execCli(String ... args) {
        this.execCli((Cli<BrooklynCommand>)this.cliBuilder().build(), args);
    }

    protected void execCli(Cli<BrooklynCommand> parser, String ... args) {
        try {
            log.debug("Parsing command line arguments: {}", Arrays.asList(args));
            BrooklynCommand command = (BrooklynCommand)parser.parse(args);
            log.debug("Executing command: {}", (Object)command);
            command.call();
            System.exit(0);
        }
        catch (ParseException pe) {
            System.err.println("Parse error: " + pe.getMessage());
            System.err.println(this.getUsageInfo(parser));
            System.exit(1);
        }
        catch (FatalConfigurationRuntimeException e) {
            log.error("Configuration error: " + e.getMessage(), e.getCause());
            System.err.println("Configuration error: " + e.getMessage());
            System.exit(3);
        }
        catch (FatalRuntimeException e) {
            log.error("Startup error: " + e.getMessage(), e.getCause());
            System.err.println("Startup error: " + e.getMessage());
            System.exit(2);
        }
        catch (Exception e) {
            log.error("Execution error: " + e.getMessage(), (Throwable)e);
            System.err.println("Execution error: " + e.getMessage());
            if (!(e instanceof UserFacingException)) {
                e.printStackTrace();
            }
            System.exit(2);
        }
    }

    protected String getUsageInfo(Cli<BrooklynCommand> parser) {
        StringBuilder help = new StringBuilder();
        help.append("\n");
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.emptyList(), (StringBuilder)help);
        return help.toString();
    }

    static {
        banner = DEFAULT_BANNER = " _                     _    _             \n| |__  _ __ ___   ___ | | _| |_   _ _ __ \n| '_ \\| '__/ _ \\ / _ \\| |/ / | | | | '_ \\ \n| |_) | | | (_) | (_) |   <| | |_| | | | |\n|_.__/|_|  \\___/ \\___/|_|\\_\\_|\\__, |_| |_|\n                              |___/             " + BrooklynVersion.get() + "\n";
        productOneLineSummary = "Apache Brooklyn, " + BrooklynVersion.get();
    }

    public static class DefaultInfoCommand
    extends InfoCommand {
        @Override
        public Void call() throws Exception {
            super.call();
            System.out.println("ERROR: No command specified.");
            System.out.println();
            throw new ParseException("No command specified.", new Object[0]);
        }
    }

    @Command(name="info", description="Display information about brooklyn")
    public static class InfoCommand
    extends BrooklynCommandCollectingArgs {
        @Override
        public Void call() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug("Invoked info command: {}", (Object)this);
            }
            this.warnIfArguments();
            System.out.println(banner);
            System.out.println("Name:     Apache Brooklyn");
            System.out.println("Version:  " + BrooklynVersion.get());
            if (BrooklynVersion.INSTANCE.isSnapshot()) {
                System.out.println("Git SHA1: " + BrooklynVersion.INSTANCE.getSha1FromOsgiManifest());
            }
            System.out.println("Website:  http://brooklyn.apache.org");
            System.out.println("Source:   https://github.com/apache/brooklyn");
            System.out.println();
            System.out.println("Copyright 2011-2016 The Apache Software Foundation.");
            System.out.println("Licensed under the Apache 2.0 License");
            System.out.println();
            return null;
        }
    }

    @Command(name="help", description="Display help for available commands")
    public static class HelpCommand
    extends BrooklynCommand {
        @Inject
        public Help help;

        @Override
        public Void call() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug("Invoked help command: {}", (Object)this);
            }
            return this.help.call();
        }
    }

    public static abstract class BrooklynCommandWithSystemDefines
    extends BrooklynCommandCollectingArgs {
        @Option(type=OptionType.GLOBAL, name={"-D"}, description="Set java system property")
        public List<String> defines1;
        @Option(name={"-D"}, description="Set java system property")
        public List<String> defines2;

        public List<String> getDefines() {
            return MutableList.copyOf(this.defines1).appendAll(this.defines2);
        }

        public Map<String, String> getDefinesAsMap() {
            return KeyValueParser.parseMap((String)Strings.join(this.getDefines(), (String)","));
        }

        public void applyDefinesAsSystemProperties() {
            System.getProperties().putAll(this.getDefinesAsMap());
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("defines", this.getDefines());
        }

        @Override
        public Void call() throws Exception {
            this.applyDefinesAsSystemProperties();
            return null;
        }
    }

    public static abstract class BrooklynCommandCollectingArgs
    extends BrooklynCommand {
        @Arguments
        public List<String> arguments = new ArrayList<String>();

        protected boolean warnIfArguments() {
            if (this.arguments.isEmpty()) {
                return false;
            }
            this.stderr.println("Invalid subcommand arguments: " + Strings.join(this.arguments, (String)" "));
            return true;
        }

        protected void failIfArguments() {
            if (this.arguments.isEmpty()) {
                return;
            }
            throw new ParseException("Invalid subcommand arguments '" + Strings.join(this.arguments, (String)" ") + "'", new Object[0]);
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("arguments", this.arguments);
        }
    }

    public static abstract class BrooklynCommand
    implements Callable<Void> {
        @Option(type=OptionType.GLOBAL, name={"-v", "--verbose"}, description="Verbose mode")
        public boolean verbose;
        @Option(type=OptionType.GLOBAL, name={"-q", "--quiet"}, description="Quiet mode")
        public boolean quiet;
        @VisibleForTesting
        protected PrintStream stdout = System.out;
        @VisibleForTesting
        protected PrintStream stderr = System.err;
        @VisibleForTesting
        protected InputStream stdin = System.in;

        public Objects.ToStringHelper string() {
            return Objects.toStringHelper(this.getClass()).add("verbose", this.verbose).add("quiet", this.quiet);
        }

        public String toString() {
            return this.string().toString();
        }
    }
}

