/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.entity.kubernetes;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.entity.docker.DockerContainer;
import org.apache.brooklyn.container.entity.kubernetes.KubernetesPodImpl;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocationConfig;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.math.MathPredicates;

@ImplementedBy(value=KubernetesPodImpl.class)
public interface KubernetesPod
extends DockerContainer {
    public static final ConfigKey<String> NAMESPACE = KubernetesLocationConfig.NAMESPACE;
    public static final ConfigKey<Boolean> PRIVILEGED = KubernetesLocationConfig.PRIVILEGED;
    public static final ConfigKey<List<String>> PERSISTENT_VOLUMES = ConfigKeys.builder((TypeToken)new TypeToken<List<String>>(){}).name("persistentVolumes").description("Persistent volumes used by the pod").build();
    public static final ConfigKey<String> DEPLOYMENT = ConfigKeys.builder(String.class).name("deployment").description("The name of the service the deployed pod will use").build();
    public static final ConfigKey<Integer> REPLICAS = ConfigKeys.builder(Integer.class).name("replicas").description("Number of replicas in the pod").constraint(MathPredicates.greaterThanOrEqual((double)1.0)).defaultValue((Object)1).build();
    public static final ConfigKey<Map<String, String>> SECRETS = ConfigKeys.builder((TypeToken)new TypeToken<Map<String, String>>(){}).name("secrets").description("Secrets to be added to the pod").build();
    public static final ConfigKey<Map<String, String>> LIMITS = ConfigKeys.builder((TypeToken)new TypeToken<Map<String, String>>(){}).name("limits").description("Container resource limits for the pod").build();
    public static final MapConfigKey<Object> METADATA = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder(Object.class, "metadata").description("Metadata to set on the pod")).defaultValue((Object)ImmutableMap.of())).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    public static final AttributeSensor<String> KUBERNETES_DEPLOYMENT = Sensors.builder(String.class, (String)"kubernetes.deployment").description("Deployment resources run in").build();
    public static final AttributeSensor<String> KUBERNETES_NAMESPACE = Sensors.builder(String.class, (String)"kubernetes.namespace").description("Namespace that resources run in").build();
    public static final AttributeSensor<String> KUBERNETES_SERVICE = Sensors.builder(String.class, (String)"kubernetes.service").description("Service that exposes the deployment").build();
    public static final AttributeSensor<String> KUBERNETES_POD = Sensors.builder(String.class, (String)"kubernetes.pod").description("Pod running the deployment").build();
    public static final String EMPTY = "Empty";
}

