/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.apidoc;

import io.swagger.annotations.Api;
import io.swagger.config.SwaggerConfig;
import io.swagger.jaxrs.config.AbstractScanner;
import io.swagger.jaxrs.config.JaxrsScanner;
import io.swagger.models.Swagger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;

public class RestApiResourceScanner
extends AbstractScanner
implements JaxrsScanner,
SwaggerConfig {
    private Set<Class<?>> apiClasses = null;

    public RestApiResourceScanner() {
    }

    public RestApiResourceScanner(Collection<Class<?>> resourceClasses) {
        this.apiClasses = new HashSet();
        this.addAnnotatedClasses(this.apiClasses, resourceClasses);
    }

    private void addAnnotatedClasses(Set<Class<?>> output, Collection<Class<?>> classes) {
        for (Class<?> clz : classes) {
            if (clz.getAnnotation(Api.class) != null) {
                output.add(clz);
            }
            this.addAnnotatedClasses(output, Arrays.asList(clz.getInterfaces()));
        }
    }

    private synchronized void buildApiClasses(Application app) {
        if (this.apiClasses == null) {
            this.apiClasses = new HashSet();
            if (app != null) {
                Set singletons;
                Set classes = app.getClasses();
                if (classes != null) {
                    this.addAnnotatedClasses(this.apiClasses, classes);
                }
                if ((singletons = app.getSingletons()) != null) {
                    for (Object o : singletons) {
                        this.addAnnotatedClasses(this.apiClasses, Arrays.asList(o.getClass()));
                    }
                }
            }
        }
    }

    public Set<Class<?>> classesFromContext(Application app, ServletConfig sc) {
        this.buildApiClasses(app);
        return this.apiClasses;
    }

    public Set<Class<?>> classes() {
        return new HashSet();
    }

    public Swagger configure(Swagger swagger) {
        swagger.setBasePath("/v1");
        return swagger;
    }

    public String getFilterClass() {
        return null;
    }
}

