/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class CacheMap
extends WeakHashMap {
    private final LinkedList cache = new LinkedList();
    private final int nSoftReferences;

    public CacheMap(int nSoftReferences) {
        if (nSoftReferences < 0) {
            throw new IllegalArgumentException("nSoftReferences = " + nSoftReferences);
        }
        this.nSoftReferences = nSoftReferences;
    }

    public Object put(Object key, Object value) {
        this.cache(key);
        return super.put(key, value);
    }

    public Object get(Object key) {
        this.cache(key);
        return super.get(key);
    }

    private void cache(Object key) {
        Iterator it = this.cache.iterator();
        while (it.hasNext()) {
            SoftReference sref = (SoftReference)it.next();
            Object key1 = sref.get();
            if (key1 == null) {
                it.remove();
                continue;
            }
            if (!key.equals(key1)) continue;
            it.remove();
            this.cache.add(0, sref);
            return;
        }
        int size = this.cache.size();
        if (size == this.nSoftReferences) {
            if (size == 0) {
                return;
            }
            it.remove();
        }
        this.cache.add(0, new SoftReference<Object>(key));
    }
}

