/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.ConfigSummary;
import org.apache.brooklyn.rest.domain.PolicyConfigSummary;

@Path(value="/applications/{application}/entities/{entity}/policies/{policy}/config")
@Api(value="Entity Policy Config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Deprecated
public interface PolicyConfigApi {
    @GET
    @ApiOperation(value="Fetch the config keys for a specific policy (deprecated, use adjuncts/ endpoint instead)", response=ConfigSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application or entity or policy")})
    public List<PolicyConfigSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch config key values in batch (deprecated, use adjuncts/ endpoint instead)", notes="Returns a map of config name to value")
    public Map<String, Object> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value (deprecated, use adjuncts/ endpoint instead)", response=Object.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application, entity, policy or config key")})
    public String get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var4);

    @POST
    @Path(value="/{config}")
    @Consumes(value={"*/*"})
    @ApiOperation(value="Sets the given config on this policy (deprecated, use adjuncts/ endpoint instead)")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application, entity, policy or config key")})
    public Response set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var4, @ApiParam(name="value", value="New value for the configuration", required=true) Object var5);
}

