/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.math.MathFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Percentage Transformer", description="Computes and advertises the percentage based on a current and total values")
public class PercentageEnricher
extends AbstractEnricher
implements SensorEventListener<Number> {
    private static final Logger LOG = LoggerFactory.getLogger(PercentageEnricher.class);
    private static final double EPSILON = 1.0E-12;
    public static final ConfigKey<AttributeSensor<? extends Number>> SOURCE_CURRENT_SENSOR = ConfigKeys.newConfigKey(new TypeToken<AttributeSensor<? extends Number>>(){}, "enricher.sourceCurrentSensor", "The sensor from which to take the current value");
    public static final ConfigKey<AttributeSensor<? extends Number>> SOURCE_TOTAL_SENSOR = ConfigKeys.newConfigKey(new TypeToken<AttributeSensor<? extends Number>>(){}, "enricher.sourceTotalSensor", "The sensor from which to take the total value");
    public static final ConfigKey<AttributeSensor<Double>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<AttributeSensor<Double>>(){}, "enricher.targetSensor", "The sensor to be set on the associated entity with the value computed here");
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity with the trigger sensor (defaults to the enricher's entity)");
    protected AttributeSensor<? extends Number> sourceCurrentSensor;
    protected AttributeSensor<? extends Number> sourceTotalSensor;
    protected AttributeSensor<Double> targetSensor;
    protected Entity producer;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.sourceCurrentSensor = (AttributeSensor)Preconditions.checkNotNull((Object)this.config().get(SOURCE_CURRENT_SENSOR), (String)"Can't add percentage enricher to entity %s as it has no %s", (Object[])new Object[]{entity, SOURCE_CURRENT_SENSOR.getName()});
        this.sourceTotalSensor = (AttributeSensor)Preconditions.checkNotNull((Object)this.config().get(SOURCE_TOTAL_SENSOR), (String)"Can't add percentage enricher to entity %s as it has no %s", (Object[])new Object[]{entity, SOURCE_TOTAL_SENSOR.getName()});
        this.targetSensor = (AttributeSensor)Preconditions.checkNotNull((Object)this.config().get(TARGET_SENSOR), (String)"Can't add percentage enricher to entity %s as it has no %s", (Object[])new Object[]{entity, TARGET_SENSOR.getName()});
        this.producer = (Entity)Objects.firstNonNull((Object)this.config().get(PRODUCER), (Object)entity);
        if (this.targetSensor.equals(this.sourceCurrentSensor) && entity.equals(this.producer)) {
            throw new IllegalArgumentException("Can't add percentage enricher to entity " + entity + " as cycle detected with " + SOURCE_CURRENT_SENSOR.getName());
        }
        if (this.targetSensor.equals(this.sourceTotalSensor) && entity.equals(this.producer)) {
            throw new IllegalArgumentException("Can't add percentage enricher to entity " + entity + " as cycle detected with " + SOURCE_TOTAL_SENSOR.getName());
        }
        this.subscriptions().subscribe((Map<String, ?>)MutableMap.of((Object)"notifyOfInitialValue", (Object)true), this.producer, this.sourceCurrentSensor, this);
        this.subscriptions().subscribe((Map<String, ?>)MutableMap.of((Object)"notifyOfInitialValue", (Object)true), this.producer, this.sourceTotalSensor, this);
        if (RendererHints.getHintsFor(this.targetSensor).isEmpty()) {
            RendererHints.register(this.targetSensor, RendererHints.displayValue(MathFunctions.percent((int)2)));
        }
    }

    public void onEvent(SensorEvent<Number> event) {
        Number current = (Number)this.producer.sensors().get(this.sourceCurrentSensor);
        if (current == null) {
            LOG.trace("Can't calculate percentage value for entity {} as current from producer {} is null", (Object)this.entity, (Object)this.producer);
            return;
        }
        Number total = (Number)this.producer.sensors().get(this.sourceTotalSensor);
        if (total == null) {
            LOG.trace("Can't calculate percentage value for entity {} as total from producer {} is null", (Object)this.entity, (Object)this.producer);
            return;
        }
        Double currentDouble = current.doubleValue();
        Double totalDouble = total.doubleValue();
        if (DoubleMath.fuzzyEquals((double)totalDouble, (double)0.0, (double)1.0E-12)) {
            LOG.trace("Can't calculate percentage value for entity {} as total from producer {} is zero", (Object)this.entity, (Object)this.producer);
            return;
        }
        if (currentDouble < 0.0 || totalDouble < 0.0) {
            LOG.trace("Can't calculate percentage value for entity {} as current ({}) or total ({}) from producer {} is negative", new Object[]{this.entity, currentDouble, totalDouble, this.producer});
            return;
        }
        Double result = currentDouble / totalDouble;
        this.emit(this.targetSensor, result);
    }
}

