/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketExtensionFactory
extends ContainerLifeCycle
implements ExtensionFactory {
    private WebSocketContainerScope container;
    private ServiceLoader<Extension> extensionLoader = ServiceLoader.load(Extension.class);
    private Map<String, Class<? extends Extension>> availableExtensions;
    private final InflaterPool inflaterPool = new InflaterPool(-1, true);
    private final DeflaterPool deflaterPool = new DeflaterPool(-1, -1, true);

    public WebSocketExtensionFactory(WebSocketContainerScope container) {
        this.availableExtensions = new HashMap<String, Class<? extends Extension>>();
        for (Extension ext : this.extensionLoader) {
            if (ext == null) continue;
            this.availableExtensions.put(ext.getName(), ext.getClass());
        }
        this.container = container;
        this.addBean(this.inflaterPool);
        this.addBean(this.deflaterPool);
    }

    public Map<String, Class<? extends Extension>> getAvailableExtensions() {
        return this.availableExtensions;
    }

    public Class<? extends Extension> getExtension(String name) {
        return this.availableExtensions.get(name);
    }

    public Set<String> getExtensionNames() {
        return this.availableExtensions.keySet();
    }

    public boolean isAvailable(String name) {
        return this.availableExtensions.containsKey(name);
    }

    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = (Extension)this.container.getObjectFactory().createInstance(extClass);
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.init(this.container);
                aext.setConfig(config);
            }
            if (ext instanceof CompressExtension) {
                CompressExtension cext = (CompressExtension)ext;
                cext.setInflaterPool(this.inflaterPool);
                cext.setDeflaterPool(this.deflaterPool);
            }
            return ext;
        }
        catch (Exception e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, (Throwable)e);
        }
    }

    public void register(String name, Class<? extends Extension> extension) {
        this.availableExtensions.put(name, extension);
    }

    public void unregister(String name) {
        this.availableExtensions.remove(name);
    }

    public Iterator<Class<? extends Extension>> iterator() {
        return this.availableExtensions.values().iterator();
    }
}

