/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecBuilder;
import io.fabric8.openshift.api.model.BuildSpecFluentImpl;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.api.model.BuildStatusBuilder;
import io.fabric8.openshift.api.model.BuildStatusFluentImpl;

public class BuildFluentImpl<A extends BuildFluent<A>>
extends BaseFluent<A>
implements BuildFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends BuildSpec, ?> spec;
    private VisitableBuilder<? extends BuildStatus, ?> status;

    public BuildFluentImpl() {
    }

    public BuildFluentImpl(Build instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public BuildFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BuildFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BuildFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public BuildFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public BuildFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public BuildSpec getSpec() {
        return this.spec != null ? (BuildSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(BuildSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new BuildSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public BuildFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public BuildFluent.SpecNested<A> withNewSpecLike(BuildSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public BuildFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public BuildFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new BuildSpecBuilder().build());
    }

    @Override
    public BuildFluent.SpecNested<A> editOrNewSpecLike(BuildSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    public BuildStatus getStatus() {
        return this.status != null ? (BuildStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(BuildStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new BuildStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public BuildFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public BuildFluent.StatusNested<A> withNewStatusLike(BuildStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public BuildFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public BuildFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new BuildStatusBuilder().build());
    }

    @Override
    public BuildFluent.StatusNested<A> editOrNewStatusLike(BuildStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildFluentImpl that = (BuildFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends BuildStatusFluentImpl<BuildFluent.StatusNested<N>>
    implements BuildFluent.StatusNested<N>,
    Nested<N> {
        private final BuildStatusBuilder builder;

        StatusNestedImpl(BuildStatus item) {
            this.builder = new BuildStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new BuildStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends BuildSpecFluentImpl<BuildFluent.SpecNested<N>>
    implements BuildFluent.SpecNested<N>,
    Nested<N> {
        private final BuildSpecBuilder builder;

        SpecNestedImpl(BuildSpec item) {
            this.builder = new BuildSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new BuildSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<BuildFluent.MetadataNested<N>>
    implements BuildFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

