/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.BindingFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;

public class BindingFluentImpl<A extends BindingFluent<A>>
extends BaseFluent<A>
implements BindingFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends ObjectReference, ?> target;

    public BindingFluentImpl() {
    }

    public BindingFluentImpl(Binding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTarget(instance.getTarget());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public BindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public BindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public BindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public ObjectReference getTarget() {
        return this.target != null ? (ObjectReference)this.target.build() : null;
    }

    @Override
    public A withTarget(ObjectReference target) {
        this._visitables.remove(this.target);
        if (target != null) {
            this.target = new ObjectReferenceBuilder(target);
            this._visitables.add(this.target);
        }
        return (A)this;
    }

    @Override
    public BindingFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public BindingFluent.TargetNested<A> withNewTargetLike(ObjectReference item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public BindingFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public BindingFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BindingFluent.TargetNested<A> editOrNewTargetLike(ObjectReference item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BindingFluentImpl that = (BindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(that.target) : that.target != null);
    }

    public class TargetNestedImpl<N>
    extends ObjectReferenceFluentImpl<BindingFluent.TargetNested<N>>
    implements BindingFluent.TargetNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        TargetNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BindingFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<BindingFluent.MetadataNested<N>>
    implements BindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

