/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private static final Collection<String> FIRST_HEADERS_TO_SIGN = ImmutableList.of((Object)"Date");
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final javax.inject.Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(SignatureWire signatureWire, @Provider Supplier<Credentials> creds, @TimeStamp javax.inject.Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.crypto = crypto;
        this.utils = utils;
        this.signatureWire = signatureWire;
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = this.replaceDateHeader(request);
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = this.replaceAuthorizationHeader(request, signature);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", new String[]{"SharedKeyLite " + ((Credentials)this.creds.get()).identity + ":" + signature})).build();
    }

    HttpRequest replaceDateHeader(HttpRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String date = (String)this.timeStampProvider.get();
        builder.put((Object)"Date", (Object)date);
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap((Map)builder.build()))).build();
        return request;
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        this.appendCanonicalizedResource(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)buffer.toString());
        }
        return buffer.toString();
    }

    private void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(HttpUtils.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentMD5())).append("\n");
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    public String calculateSignature(String toSign) throws HttpException {
        String signature = this.signString(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream((String)signature));
        }
        return signature;
    }

    public String signString(String toSign) {
        try {
            ByteProcessor hmacSHA256 = Macs.asByteProcessor((Mac)this.crypto.hmacSHA256(BaseEncoding.base64().decode((CharSequence)((Credentials)this.creds.get()).credential)));
            return BaseEncoding.base64().encode((byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)toSign), (ByteProcessor)hmacSHA256));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
    }

    private void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    private void appendCanonicalizedHeaders(HttpRequest request, StringBuilder toSign) {
        TreeMap headers = Maps.newTreeMap();
        Multimap requestHeaders = request.getHeaders();
        for (String string : requestHeaders.keySet()) {
            if (!string.startsWith("x-ms-")) continue;
            String value = Joiner.on((String)",").join(Iterables.transform((Iterable)requestHeaders.get((Object)string), (Function)new Function<String, Object>(){

                public Object apply(String value) {
                    return Patterns.NEWLINE_PATTERN.matcher(value).replaceAll("");
                }
            }));
            headers.put(string.toLowerCase(), value);
        }
        for (Map.Entry entry : headers.entrySet()) {
            toSign.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
        }
    }

    private void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        for (String header : FIRST_HEADERS_TO_SIGN) {
            toSign.append(HttpUtils.nullToEmpty((Collection)request.getHeaders().get((Object)header))).append("\n");
        }
    }

    @VisibleForTesting
    void appendCanonicalizedResource(HttpRequest request, StringBuilder toSign) {
        toSign.append("/").append(((Credentials)this.creds.get()).identity);
        this.appendUriPath(request, toSign);
    }

    @VisibleForTesting
    void appendUriPath(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath());
        if (request.getEndpoint().getQuery() != null) {
            String[] params;
            StringBuilder paramsToSign = new StringBuilder("?");
            for (String param : params = request.getEndpoint().getQuery().split("&")) {
                String[] paramNameAndValue = param.split("=");
                if (!"comp".equals(paramNameAndValue[0])) continue;
                paramsToSign.append(param);
            }
            if (paramsToSign.length() > 1) {
                toSign.append((CharSequence)paramsToSign);
            }
        }
    }
}

