/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.common.net.InetSocketAddressHelper;
import com.twitter.util.Await;
import com.twitter.util.Duration;
import com.twitter.util.Function;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import com.twitter.util.ScheduledThreadPoolTimer;
import com.twitter.util.Timer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.client.resolver.DefaultRegionResolver;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.common.rate.MovingAverageRate;
import org.apache.distributedlog.common.rate.MovingAverageRateFactory;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.RegionUnavailableException;
import org.apache.distributedlog.exceptions.ServiceUnavailableException;
import org.apache.distributedlog.exceptions.StreamUnavailableException;
import org.apache.distributedlog.exceptions.TooManyStreamsException;
import org.apache.distributedlog.feature.AbstractFeatureProvider;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.FatalErrorHandler;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.ServerFeatureKeys;
import org.apache.distributedlog.service.config.ServerConfiguration;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.apache.distributedlog.service.placement.LeastLoadPlacementPolicy;
import org.apache.distributedlog.service.placement.LoadAppraiser;
import org.apache.distributedlog.service.placement.PlacementPolicy;
import org.apache.distributedlog.service.placement.ZKPlacementStateManager;
import org.apache.distributedlog.service.stream.BulkWriteOp;
import org.apache.distributedlog.service.stream.DeleteOp;
import org.apache.distributedlog.service.stream.HeartbeatOp;
import org.apache.distributedlog.service.stream.ReleaseOp;
import org.apache.distributedlog.service.stream.Stream;
import org.apache.distributedlog.service.stream.StreamFactory;
import org.apache.distributedlog.service.stream.StreamFactoryImpl;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.StreamManagerImpl;
import org.apache.distributedlog.service.stream.StreamOp;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.service.stream.TruncateOp;
import org.apache.distributedlog.service.stream.WriteOp;
import org.apache.distributedlog.service.stream.WriteOpWithPayload;
import org.apache.distributedlog.service.stream.admin.CreateOp;
import org.apache.distributedlog.service.stream.admin.StreamAdminOp;
import org.apache.distributedlog.service.stream.limiter.ServiceRequestLimiter;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.apache.distributedlog.service.utils.ServerUtils;
import org.apache.distributedlog.thrift.service.BulkWriteResponse;
import org.apache.distributedlog.thrift.service.ClientInfo;
import org.apache.distributedlog.thrift.service.DistributedLogService;
import org.apache.distributedlog.thrift.service.HeartbeatOptions;
import org.apache.distributedlog.thrift.service.ResponseHeader;
import org.apache.distributedlog.thrift.service.ServerInfo;
import org.apache.distributedlog.thrift.service.ServerStatus;
import org.apache.distributedlog.thrift.service.StatusCode;
import org.apache.distributedlog.thrift.service.WriteContext;
import org.apache.distributedlog.thrift.service.WriteResponse;
import org.apache.distributedlog.util.ConfUtils;
import org.apache.distributedlog.util.OrderedScheduler;
import org.jboss.netty.util.HashedWheelTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxedUnit;

public class DistributedLogServiceImpl
implements DistributedLogService.ServiceIface,
FatalErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLogServiceImpl.class);
    private static final int MOVING_AVERAGE_WINDOW_SECS = 60;
    private final ServerConfiguration serverConfig;
    private final DistributedLogConfiguration dlConfig;
    private final Namespace dlNamespace;
    private final int serverRegionId;
    private final PlacementPolicy placementPolicy;
    private ServerStatus serverStatus = ServerStatus.WRITE_AND_ACCEPT;
    private final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final CountDownLatch keepAliveLatch;
    private final byte dlsnVersion;
    private final String clientId;
    private final OrderedScheduler scheduler;
    private final AccessControlManager accessControlManager;
    private final StreamConfigProvider streamConfigProvider;
    private final StreamManager streamManager;
    private final StreamFactory streamFactory;
    private final RoutingService routingService;
    private final RegionResolver regionResolver;
    private final MovingAverageRateFactory movingAvgFactory;
    private final MovingAverageRate windowedRps;
    private final MovingAverageRate windowedBps;
    private final ServiceRequestLimiter limiter;
    private final Timer timer;
    private final HashedWheelTimer requestTimer;
    private final FeatureProvider featureProvider;
    private final Feature featureRegionStopAcceptNewStream;
    private final Feature featureChecksumDisabled;
    private final Feature limiterDisabledFeature;
    private final StatsLogger statsLogger;
    private final StatsLogger perStreamStatsLogger;
    private final StreamPartitionConverter streamPartitionConverter;
    private final StreamOpStats streamOpStats;
    private final Counter bulkWritePendingStat;
    private final Counter writePendingStat;
    private final Counter redirects;
    private final Counter receivedRecordCounter;
    private final StatsLogger statusCodeStatLogger;
    private final ConcurrentHashMap<StatusCode, Counter> statusCodeCounters = new ConcurrentHashMap();
    private final Counter statusCodeTotal;
    private final Gauge<Number> proxyStatusGauge;
    private final Gauge<Number> movingAvgRpsGauge;
    private final Gauge<Number> movingAvgBpsGauge;
    private final Gauge<Number> streamAcquiredGauge;
    private final Gauge<Number> streamCachedGauge;
    private final int shard;

    DistributedLogServiceImpl(ServerConfiguration serverConf, DistributedLogConfiguration dlConf, DynamicDistributedLogConfiguration dynDlConf, StreamConfigProvider streamConfigProvider, URI uri, StreamPartitionConverter converter, RoutingService routingService, StatsLogger statsLogger, StatsLogger perStreamStatsLogger, CountDownLatch keepAliveLatch, LoadAppraiser loadAppraiser) throws IOException {
        this.serverConfig = serverConf;
        this.dlConfig = dlConf;
        this.perStreamStatsLogger = perStreamStatsLogger;
        this.dlsnVersion = serverConf.getDlsnVersion();
        this.serverRegionId = serverConf.getRegionId();
        this.streamPartitionConverter = converter;
        int serverPort = serverConf.getServerPort();
        this.shard = serverConf.getServerShardId();
        int numThreads = serverConf.getServerThreads();
        this.clientId = DLSocketAddress.toLockId((InetSocketAddress)DLSocketAddress.getSocketAddress((int)serverPort), (int)this.shard);
        String allocatorPoolName = ServerUtils.getLedgerAllocatorPoolName(this.serverRegionId, this.shard, serverConf.isUseHostnameAsAllocatorPoolName());
        dlConf.setLedgerAllocatorPoolName(allocatorPoolName);
        this.featureProvider = AbstractFeatureProvider.getFeatureProvider((String)"", (DistributedLogConfiguration)dlConf, (StatsLogger)statsLogger.scope("features"));
        if (this.featureProvider instanceof AbstractFeatureProvider) {
            ((AbstractFeatureProvider)this.featureProvider).start();
        }
        this.dlNamespace = NamespaceBuilder.newBuilder().conf(dlConf).uri(uri).statsLogger(statsLogger).featureProvider(this.featureProvider).clientId(this.clientId).regionId(this.serverRegionId).build();
        this.accessControlManager = this.dlNamespace.createAccessControlManager();
        this.keepAliveLatch = keepAliveLatch;
        this.streamConfigProvider = streamConfigProvider;
        this.streamOpStats = new StreamOpStats(statsLogger, perStreamStatsLogger);
        this.scheduler = OrderedScheduler.newBuilder().corePoolSize(numThreads).name("DistributedLogService-Executor").build();
        this.requestTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("DLServiceTimer-%d").build(), dlConf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, dlConf.getTimeoutTimerNumTicks());
        this.streamFactory = new StreamFactoryImpl(this.clientId, this.streamOpStats, serverConf, dlConf, this.featureProvider, streamConfigProvider, converter, this.dlNamespace, this.scheduler, this, this.requestTimer);
        this.streamManager = new StreamManagerImpl(this.clientId, dlConf, (ScheduledExecutorService)this.scheduler, this.streamFactory, converter, streamConfigProvider, this.dlNamespace);
        this.routingService = routingService;
        this.regionResolver = new DefaultRegionResolver();
        this.featureRegionStopAcceptNewStream = this.featureProvider.getFeature(ServerFeatureKeys.REGION_STOP_ACCEPT_NEW_STREAM.name().toLowerCase());
        this.featureChecksumDisabled = this.featureProvider.getFeature(ServerFeatureKeys.SERVICE_CHECKSUM_DISABLED.name().toLowerCase());
        this.limiterDisabledFeature = this.featureProvider.getFeature(ServerFeatureKeys.SERVICE_GLOBAL_LIMITER_DISABLED.name().toLowerCase());
        this.timer = new ScheduledThreadPoolTimer(1, "timer", true);
        this.movingAvgFactory = new MovingAverageRateFactory((ScheduledExecutorService)this.scheduler);
        this.windowedRps = this.movingAvgFactory.create(60);
        this.windowedBps = this.movingAvgFactory.create(60);
        this.limiter = new ServiceRequestLimiter(dynDlConf, this.streamOpStats.baseScope("service_limiter"), this.windowedRps, this.windowedBps, this.streamManager, this.limiterDisabledFeature);
        this.placementPolicy = new LeastLoadPlacementPolicy(loadAppraiser, routingService, this.dlNamespace, new ZKPlacementStateManager(uri, dlConf, statsLogger), Duration.fromSeconds((int)serverConf.getResourcePlacementRefreshInterval()), statsLogger);
        logger.info("placement started");
        this.statsLogger = statsLogger;
        this.proxyStatusGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return ServerStatus.DOWN == DistributedLogServiceImpl.this.serverStatus ? -1 : (DistributedLogServiceImpl.this.featureRegionStopAcceptNewStream.isAvailable() ? 3 : (ServerStatus.WRITE_AND_ACCEPT == DistributedLogServiceImpl.this.serverStatus ? 1 : 2));
            }
        };
        this.movingAvgRpsGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return DistributedLogServiceImpl.this.windowedRps.get();
            }
        };
        this.movingAvgBpsGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return DistributedLogServiceImpl.this.windowedBps.get();
            }
        };
        this.streamAcquiredGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return DistributedLogServiceImpl.this.streamManager.numAcquired();
            }
        };
        this.streamCachedGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return DistributedLogServiceImpl.this.streamManager.numCached();
            }
        };
        statsLogger.registerGauge("proxy_status", this.proxyStatusGauge);
        statsLogger.registerGauge("moving_avg_rps", this.movingAvgRpsGauge);
        statsLogger.registerGauge("moving_avg_bps", this.movingAvgBpsGauge);
        this.bulkWritePendingStat = this.streamOpStats.requestPendingCounter("bulkWritePending");
        this.writePendingStat = this.streamOpStats.requestPendingCounter("writePending");
        this.redirects = this.streamOpStats.requestCounter("redirect");
        this.statusCodeStatLogger = this.streamOpStats.requestScope("statuscode");
        this.statusCodeTotal = this.streamOpStats.requestCounter("statuscode_count");
        this.receivedRecordCounter = this.streamOpStats.recordsCounter("received");
        StatsLogger streamsStatsLogger = statsLogger.scope("streams");
        streamsStatsLogger.registerGauge("acquired", this.streamAcquiredGauge);
        streamsStatsLogger.registerGauge("cached", this.streamCachedGauge);
        logger.info("Running distributedlog server : client id {}, allocator pool {}, perstream stat {}, dlsn version {}.", new Object[]{this.clientId, allocatorPoolName, serverConf.isPerStreamStatEnabled(), this.dlsnVersion});
    }

    private void countStatusCode(StatusCode code) {
        Counter oldCounter;
        Counter counter = this.statusCodeCounters.get(code);
        if (null == counter && null != (oldCounter = this.statusCodeCounters.putIfAbsent(code, counter = this.statusCodeStatLogger.getCounter(code.name())))) {
            counter = oldCounter;
        }
        counter.inc();
        this.statusCodeTotal.inc();
    }

    public Future<ServerInfo> handshake() {
        return this.handshakeWithClientInfo(new ClientInfo());
    }

    public Future<ServerInfo> handshakeWithClientInfo(ClientInfo clientInfo) {
        ServerInfo serverInfo = new ServerInfo();
        this.closeLock.readLock().lock();
        try {
            serverInfo.setServerStatus(this.serverStatus);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
        if (clientInfo.isSetGetOwnerships() && !clientInfo.isGetOwnerships()) {
            return Future.value((Object)serverInfo);
        }
        Optional regex = Optional.absent();
        if (clientInfo.isSetStreamNameRegex()) {
            regex = Optional.of((Object)clientInfo.getStreamNameRegex());
        }
        Map<String, String> ownershipMap = this.streamManager.getStreamOwnershipMap((Optional<String>)regex);
        serverInfo.setOwnerships(ownershipMap);
        return Future.value((Object)serverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Stream getLogWriter(String stream) throws IOException {
        Stream writer = this.streamManager.getStream(stream);
        if (null == writer) {
            this.closeLock.readLock().lock();
            try {
                if (this.featureRegionStopAcceptNewStream.isAvailable()) {
                    throw new RegionUnavailableException("Region is unavailable right now.");
                }
                if (ServerStatus.WRITE_AND_ACCEPT != this.serverStatus) {
                    Stream stream2 = null;
                    return stream2;
                }
                writer = this.streamManager.getOrCreateStream(stream, true);
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        }
        return writer;
    }

    public Future<WriteResponse> write(String stream, ByteBuffer data) {
        this.receivedRecordCounter.inc();
        return this.doWrite(stream, data, null, false);
    }

    public Future<BulkWriteResponse> writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx) {
        this.bulkWritePendingStat.inc();
        this.receivedRecordCounter.add((long)data.size());
        BulkWriteOp op = new BulkWriteOp(stream, data, this.statsLogger, this.perStreamStatsLogger, this.streamPartitionConverter, this.getChecksum(ctx), this.featureChecksumDisabled, this.accessControlManager);
        this.executeStreamOp(op);
        return op.result().ensure((Function0)new com.twitter.util.Function0<BoxedUnit>(){

            public BoxedUnit apply() {
                DistributedLogServiceImpl.this.bulkWritePendingStat.dec();
                return null;
            }
        });
    }

    public Future<WriteResponse> writeWithContext(String stream, ByteBuffer data, WriteContext ctx) {
        return this.doWrite(stream, data, this.getChecksum(ctx), ctx.isIsRecordSet());
    }

    public Future<WriteResponse> heartbeat(String stream, WriteContext ctx) {
        HeartbeatOp op = new HeartbeatOp(stream, this.statsLogger, this.perStreamStatsLogger, this.dlsnVersion, this.getChecksum(ctx), this.featureChecksumDisabled, this.accessControlManager);
        this.executeStreamOp(op);
        return op.result();
    }

    public Future<WriteResponse> heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options) {
        HeartbeatOp op = new HeartbeatOp(stream, this.statsLogger, this.perStreamStatsLogger, this.dlsnVersion, this.getChecksum(ctx), this.featureChecksumDisabled, this.accessControlManager);
        if (options.isSendHeartBeatToReader()) {
            op.setWriteControlRecord(true);
        }
        this.executeStreamOp(op);
        return op.result();
    }

    public Future<WriteResponse> truncate(String stream, String dlsn, WriteContext ctx) {
        TruncateOp op = new TruncateOp(stream, DLSN.deserialize((String)dlsn), this.statsLogger, this.perStreamStatsLogger, this.getChecksum(ctx), this.featureChecksumDisabled, this.accessControlManager);
        this.executeStreamOp(op);
        return op.result();
    }

    public Future<WriteResponse> delete(String stream, WriteContext ctx) {
        DeleteOp op = new DeleteOp(stream, this.statsLogger, this.perStreamStatsLogger, this.streamManager, this.getChecksum(ctx), this.featureChecksumDisabled, this.accessControlManager);
        this.executeStreamOp(op);
        return op.result();
    }

    public Future<WriteResponse> release(String stream, WriteContext ctx) {
        ReleaseOp op = new ReleaseOp(stream, this.statsLogger, this.perStreamStatsLogger, this.streamManager, this.getChecksum(ctx), this.featureChecksumDisabled, this.accessControlManager);
        this.executeStreamOp(op);
        return op.result();
    }

    public Future<WriteResponse> create(String stream, WriteContext ctx) {
        CreateOp op = new CreateOp(stream, this.statsLogger, this.streamManager, this.getChecksum(ctx), this.featureChecksumDisabled);
        return this.executeStreamAdminOp(op);
    }

    public Future<WriteResponse> getOwner(String streamName, WriteContext ctx) {
        if (this.streamManager.isAcquired(streamName)) {
            return Future.value((Object)new WriteResponse(ResponseUtils.ownerToHeader(this.clientId)));
        }
        return this.placementPolicy.placeStream(streamName).map((Function1)new Function<String, WriteResponse>(){

            public WriteResponse apply(String server) {
                String host = DLSocketAddress.toLockId((InetSocketAddress)InetSocketAddressHelper.parse((String)server), (int)-1);
                return new WriteResponse(ResponseUtils.ownerToHeader(host));
            }
        });
    }

    public Future<Void> setAcceptNewStream(boolean enabled) {
        this.closeLock.writeLock().lock();
        try {
            logger.info("Set AcceptNewStream = {}", (Object)enabled);
            if (ServerStatus.DOWN != this.serverStatus) {
                this.serverStatus = enabled ? ServerStatus.WRITE_AND_ACCEPT : ServerStatus.WRITE_ONLY;
            }
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        return Future.Void();
    }

    private Future<WriteResponse> doWrite(String name, ByteBuffer data, Long checksum, boolean isRecordSet) {
        this.writePendingStat.inc();
        this.receivedRecordCounter.inc();
        WriteOp op = this.newWriteOp(name, data, checksum, isRecordSet);
        this.executeStreamOp(op);
        return op.result().ensure((Function0)new com.twitter.util.Function0<BoxedUnit>(){

            public BoxedUnit apply() {
                DistributedLogServiceImpl.this.writePendingStat.dec();
                return null;
            }
        });
    }

    private Long getChecksum(WriteContext ctx) {
        return ctx.isSetCrc32() ? Long.valueOf(ctx.getCrc32()) : null;
    }

    private Future<WriteResponse> executeStreamAdminOp(StreamAdminOp op) {
        try {
            op.preExecute();
        }
        catch (DLException dle) {
            return Future.exception((Throwable)dle);
        }
        return op.execute();
    }

    private void executeStreamOp(StreamOp op) {
        Stream stream;
        op.responseHeader().addEventListener((FutureEventListener)new FutureEventListener<ResponseHeader>(){

            public void onSuccess(ResponseHeader header) {
                if (header.getLocation() != null || header.getCode() == StatusCode.FOUND) {
                    DistributedLogServiceImpl.this.redirects.inc();
                }
                DistributedLogServiceImpl.this.countStatusCode(header.getCode());
            }

            public void onFailure(Throwable cause) {
            }
        });
        try {
            this.limiter.apply(op);
            op.preExecute();
        }
        catch (TooManyStreamsException e) {
            op.fail((Throwable)new StreamUnavailableException(e.getMessage()));
            return;
        }
        catch (Exception e) {
            op.fail(e);
            return;
        }
        try {
            stream = this.getLogWriter(op.streamName());
        }
        catch (RegionUnavailableException rue) {
            op.fail(new RegionUnavailableException("Region " + this.serverRegionId + " is unavailable."));
            return;
        }
        catch (IOException e) {
            op.fail(e);
            return;
        }
        if (null == stream) {
            op.fail((Throwable)new ServiceUnavailableException("Server " + this.clientId + " is closed."));
            return;
        }
        if (op instanceof WriteOpWithPayload) {
            WriteOpWithPayload writeOp = (WriteOpWithPayload)((Object)op);
            this.windowedBps.add(writeOp.getPayloadSize());
            this.windowedRps.inc();
        }
        stream.submit(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        try {
            this.closeLock.writeLock().lock();
            try {
                if (ServerStatus.DOWN == this.serverStatus) {
                    return;
                }
                this.serverStatus = ServerStatus.DOWN;
            }
            finally {
                this.closeLock.writeLock().unlock();
            }
            this.streamManager.close();
            this.movingAvgFactory.close();
            this.limiter.close();
            Stopwatch closeStreamsStopwatch = Stopwatch.createStarted();
            Future<List<Void>> closeResult = this.streamManager.closeStreams();
            logger.info("Waiting for closing all streams ...");
            try {
                Await.result(closeResult, (Duration)Duration.fromTimeUnit((long)5L, (TimeUnit)TimeUnit.MINUTES));
                logger.info("Closed all streams in {} millis.", (Object)closeStreamsStopwatch.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted on waiting for closing all streams : ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.warn("Sorry, we didn't close all streams gracefully in 5 minutes : ", (Throwable)e);
            }
            logger.info("Closing distributedlog namespace ...");
            this.dlNamespace.close();
            logger.info("Closed distributedlog namespace .");
            if (this.featureProvider instanceof AbstractFeatureProvider) {
                ((AbstractFeatureProvider)this.featureProvider).stop();
            }
            this.timer.stop();
            this.placementPolicy.close();
            this.unregisterGauge();
            SchedulerUtils.shutdownScheduler((ExecutorService)this.scheduler, (long)60L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            logger.info("Exception while shutting down distributedlog service.");
        }
        finally {
            this.keepAliveLatch.countDown();
            logger.info("Finished shutting down distributedlog service.");
        }
    }

    protected void startPlacementPolicy() {
        this.placementPolicy.start(this.shard == 0);
    }

    @Override
    public void notifyFatalError() {
        this.triggerShutdown();
    }

    private void triggerShutdown() {
        logger.info("Releasing KeepAlive Latch to trigger shutdown ...");
        this.keepAliveLatch.countDown();
        logger.info("Released KeepAlive Latch. Main thread will shut the service down.");
    }

    private DynamicDistributedLogConfiguration getDynConf(String streamName) {
        Optional<DynamicDistributedLogConfiguration> dynDlConf = this.streamConfigProvider.getDynamicStreamConfig(streamName);
        if (dynDlConf.isPresent()) {
            return (DynamicDistributedLogConfiguration)dynDlConf.get();
        }
        return ConfUtils.getConstDynConf((DistributedLogConfiguration)this.dlConfig);
    }

    private void unregisterGauge() {
        this.statsLogger.unregisterGauge("proxy_status", this.proxyStatusGauge);
        this.statsLogger.unregisterGauge("moving_avg_rps", this.movingAvgRpsGauge);
        this.statsLogger.unregisterGauge("moving_avg_bps", this.movingAvgBpsGauge);
        this.statsLogger.unregisterGauge("acquired", this.streamAcquiredGauge);
        this.statsLogger.unregisterGauge("cached", this.streamCachedGauge);
    }

    @VisibleForTesting
    Stream newStream(String name) throws IOException {
        return this.streamManager.getOrCreateStream(name, false);
    }

    @VisibleForTesting
    WriteOp newWriteOp(String stream, ByteBuffer data, Long checksum) {
        return this.newWriteOp(stream, data, checksum, false);
    }

    @VisibleForTesting
    RoutingService getRoutingService() {
        return this.routingService;
    }

    @VisibleForTesting
    DLSocketAddress getServiceAddress() throws IOException {
        return DLSocketAddress.deserialize((String)this.clientId);
    }

    WriteOp newWriteOp(String stream, ByteBuffer data, Long checksum, boolean isRecordSet) {
        return new WriteOp(stream, data, this.statsLogger, this.perStreamStatsLogger, this.streamPartitionConverter, this.serverConfig, this.dlsnVersion, checksum, isRecordSet, this.featureChecksumDisabled, this.accessControlManager);
    }

    @VisibleForTesting
    Future<List<Void>> closeStreams() {
        return this.streamManager.closeStreams();
    }

    @VisibleForTesting
    public Namespace getDistributedLogNamespace() {
        return this.dlNamespace;
    }

    @VisibleForTesting
    StreamManager getStreamManager() {
        return this.streamManager;
    }
}

