/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.twitter.finagle.NoBrokersAvailableException;
import com.twitter.finagle.stats.StatsReceiver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.routing.ServerSetWatcher;
import org.apache.distributedlog.service.DLSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerSetRoutingService
extends Thread
implements RoutingService {
    private static final Logger logger = LoggerFactory.getLogger(ServerSetRoutingService.class);
    private final ServerSetWatcher serverSetWatcher;
    private final Set<SocketAddress> hostSet = new HashSet<SocketAddress>();
    private List<SocketAddress> hostList = new ArrayList<SocketAddress>();
    private final HashFunction hasher = Hashing.md5();
    private final AtomicReference<ImmutableSet<DLSocketAddress>> serverSetChange = new AtomicReference<Object>(null);
    private final CountDownLatch changeLatch = new CountDownLatch(1);
    protected final CopyOnWriteArraySet<RoutingService.RoutingListener> listeners = new CopyOnWriteArraySet();

    static ServerSetRoutingServiceBuilder newServerSetRoutingServiceBuilder() {
        return new ServerSetRoutingServiceBuilder();
    }

    ServerSetRoutingService(ServerSetWatcher serverSetWatcher) {
        super("ServerSetRoutingService");
        this.serverSetWatcher = serverSetWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getHosts() {
        Set<SocketAddress> set = this.hostSet;
        synchronized (set) {
            return ImmutableSet.copyOf(this.hostSet);
        }
    }

    @Override
    public void startService() {
        this.start();
        try {
            if (!this.changeLatch.await(1L, TimeUnit.MINUTES)) {
                logger.warn("No serverset change received in 1 minute.");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted waiting first serverset change : ", (Throwable)e);
        }
        logger.info("{} Routing Service Started.", (Object)this.getClass().getSimpleName());
    }

    @Override
    public void stopService() {
        Thread.currentThread().interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted on waiting serverset routing service to finish : ", (Throwable)e);
        }
        logger.info("{} Routing Service Stopped.", (Object)this.getClass().getSimpleName());
    }

    @Override
    public RoutingService registerListener(RoutingService.RoutingListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public RoutingService unregisterListener(RoutingService.RoutingListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getHost(String key, RoutingService.RoutingContext rContext) throws NoBrokersAvailableException {
        SocketAddress address = null;
        Set<SocketAddress> set = this.hostSet;
        synchronized (set) {
            int hashCode;
            int hostId;
            if (0 != this.hostList.size() && rContext.isTriedHost(address = this.hostList.get(hostId = ServerSetRoutingService.signSafeMod(hashCode = this.hasher.hashUnencodedChars((CharSequence)key).asInt(), this.hostList.size())))) {
                ArrayList<SocketAddress> newList = new ArrayList<SocketAddress>(this.hostList);
                newList.remove(hostId);
                hostId = ServerSetRoutingService.signSafeMod(hashCode, newList.size());
                address = newList.get(hostId);
                int i = hostId;
                while (rContext.isTriedHost(address)) {
                    if ((i = (i + 1) % newList.size()) == hostId) {
                        address = null;
                        break;
                    }
                    address = newList.get(i);
                }
            }
        }
        if (null == address) {
            throw new NoBrokersAvailableException("No host is available.");
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHost(SocketAddress host, Throwable reason) {
        Set<SocketAddress> set = this.hostSet;
        synchronized (set) {
            if (this.hostSet.remove(host)) {
                logger.info("Node {} left due to : ", (Object)host, (Object)reason);
            }
            this.hostList = new ArrayList<SocketAddress>(this.hostSet);
            Collections.sort(this.hostList, HostComparator.INSTANCE);
            logger.info("Host list becomes : {}.", this.hostList);
        }
    }

    @Override
    public void run() {
        try {
            this.serverSetWatcher.watch(new ServerSetWatcher.ServerSetMonitor(){

                @Override
                public void onChange(ImmutableSet<DLSocketAddress> serviceInstances) {
                    ImmutableSet<DLSocketAddress> lastValue = ServerSetRoutingService.this.serverSetChange.getAndSet(serviceInstances);
                    if (null == lastValue) {
                        ImmutableSet mostRecentValue;
                        do {
                            mostRecentValue = (ImmutableSet)ServerSetRoutingService.this.serverSetChange.get();
                            ServerSetRoutingService.this.performServerSetChange((ImmutableSet<DLSocketAddress>)mostRecentValue);
                            ServerSetRoutingService.this.changeLatch.countDown();
                        } while (!ServerSetRoutingService.this.serverSetChange.compareAndSet(mostRecentValue, null));
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Fail to monitor server set : ", (Throwable)e);
            Runtime.getRuntime().exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void performServerSetChange(ImmutableSet<DLSocketAddress> serverSet) {
        ImmutableSet added;
        ImmutableSet removed;
        HashSet<InetSocketAddress> newSet = new HashSet<InetSocketAddress>();
        for (DLSocketAddress serviceInstance : serverSet) {
            newSet.add(serviceInstance.getSocketAddress());
        }
        Object object = this.hostSet;
        synchronized (object) {
            removed = Sets.difference(this.hostSet, newSet).immutableCopy();
            added = Sets.difference(newSet, this.hostSet).immutableCopy();
            for (SocketAddress node : removed) {
                if (!this.hostSet.remove(node)) continue;
                logger.info("Node {} left.", (Object)node);
            }
            for (SocketAddress node : added) {
                if (!this.hostSet.add(node)) continue;
                logger.info("Node {} joined.", (Object)node);
            }
        }
        for (SocketAddress addr : removed) {
            for (RoutingService.RoutingListener listener : this.listeners) {
                listener.onServerLeft(addr);
            }
        }
        for (SocketAddress addr : added) {
            for (RoutingService.RoutingListener listener : this.listeners) {
                listener.onServerJoin(addr);
            }
        }
        object = this.hostSet;
        synchronized (object) {
            this.hostList = new ArrayList<SocketAddress>(this.hostSet);
            Collections.sort(this.hostList, HostComparator.INSTANCE);
            logger.info("Host list becomes : {}.", this.hostList);
        }
    }

    static int signSafeMod(long dividend, int divisor) {
        int mod = (int)(dividend % (long)divisor);
        if (mod < 0) {
            mod += divisor;
        }
        return mod;
    }

    private static class HostComparator
    implements Comparator<SocketAddress> {
        private static final HostComparator INSTANCE = new HostComparator();

        private HostComparator() {
        }

        @Override
        public int compare(SocketAddress o1, SocketAddress o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    static class ServerSetRoutingServiceBuilder
    implements RoutingService.Builder {
        private ServerSetWatcher serverSetWatcher;

        private ServerSetRoutingServiceBuilder() {
        }

        public ServerSetRoutingServiceBuilder serverSetWatcher(ServerSetWatcher serverSetWatcher) {
            this.serverSetWatcher = serverSetWatcher;
            return this;
        }

        @Override
        public RoutingService.Builder statsReceiver(StatsReceiver statsReceiver) {
            return this;
        }

        @Override
        public RoutingService build() {
            Preconditions.checkNotNull((Object)this.serverSetWatcher, (Object)"No serverset watcher provided.");
            return new ServerSetRoutingService(this.serverSetWatcher);
        }
    }
}

