/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Verifier;
import com.twitter.common.args.apt.Configuration;
import com.twitter.common.collections.Pair;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.annotation.Nullable;

public final class Verifiers {
    private final ImmutableMap<Pair<Class<?>, Class<? extends Annotation>>, Verifier<?>> registry;

    private Verifiers(Map<Pair<Class<?>, Class<? extends Annotation>>, Verifier<?>> registry) {
        this.registry = ImmutableMap.copyOf(registry);
    }

    @Nullable
    <T> Verifier<T> get(TypeToken<T> type, Annotation constraint) {
        for (Map.Entry entry : this.registry.entrySet()) {
            if (((Pair)entry.getKey()).getSecond() != constraint.annotationType() || !((Class)((Pair)entry.getKey()).getFirst()).isAssignableFrom(type.getRawType())) continue;
            Verifier verifier = (Verifier)entry.getValue();
            return verifier;
        }
        return null;
    }

    static Verifiers fromConfiguration(Configuration configuration) {
        ImmutableMap.Builder registry = ImmutableMap.builder();
        for (Configuration.VerifierInfo info : configuration.verifierInfo()) {
            Class verifiedType = Verifiers.forName(info.verifiedType);
            Class verifyingAnnotation = Verifiers.forName(info.verifyingAnnotation);
            Class verifierClass = Verifiers.forName(info.verifierClass);
            try {
                registry.put((Object)Pair.of(verifiedType, verifyingAnnotation), verifierClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
        }
        return new Verifiers((Map<Pair<Class<?>, Class<? extends Annotation>>, Verifier<?>>)registry.build());
    }

    private static <T> Class<T> forName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new Configuration.ConfigurationException((Throwable)e);
        }
    }
}

